/* Convert WebOOGL into OOGL 
   by Tamara Munzner 28 March 1995
   Copyright 1995 The Geometry Center
   Publically distributable under the terms of the GNU License 
*/

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>

main(int argc, char *argv[]) 
{
  int c;
  int buf[1024]; 
  int open, close, uniqhref, lasturl, balance, where, url, i, j, uniq = 0;
  int uniqurl = -1;
  char *handle = NULL;
  int browser_pid = 0;
  char *nurls[1024];
  int unique = 0;
  int pid = getpid();
  int toss = 0;

  if (argc == 2) {
    handle = argv[1];
  } else if (argc > 2) {
    fprintf(stderr, "Usage: woogl2oogl [handle] < wooglfile > ooglfile\nConvert WebOOGL file into straight OOGL file.\nhandle: Return GCL not OOGL, where the OOGL geometry is defined as the handle.\nThe handle generally corresponds to a URL.\n");
    exit(1);
  }

  if (handle) {
    printf("(progn (read geometry {define \"%s\" {\n", handle);
  }

  /* parse character by character
     don't forget to throw out everything after '#' on a line...
     */
  while ((c = getchar()) != EOF) {
    if (c == '#') {
      toss = 1;
    } else if (c == '\n') {
      toss = 0;
    }
    if (toss == 1) {
      /* no-op */
    } else if (c == '>') {
      printf(" COMMENT www.%d HREF { ", uniqhref++);
      balance = open;
    } else if (c == '<') {
      buf[where++] = '<';
      /* can't tell if it's a filename or a relative URL.
	 sigh. assume it's a URL. 
	 */
    } else if (where) {
      buf[where++] = c;
      /* if (c == ':') url=1; */
      url = 1;
      if (c == '}') {
	open--;
	if (url) {
	  /* compare URL against previously seen ones */
	  uniq = 0;
	  i = 0;
	  if (i > uniqurl) uniq = 1;
	  for (; !uniq && i <= uniqurl; i++) {
	    if (!nurls[i]) uniq = 1;
	    for (j = 1; !uniq && nurls[i][j-1] != '\0'; j++) {

	      if ((char) buf[j] != ' ' && 
		  (char) buf[j] != '\n' && 
		  (char) buf[j] != '\t' && 
		  (nurls[i][j-1] != (char) buf[j])) {
		uniq = 1;
	      }
	    }
	  }
	  if (handle) {
	    /* save url into buffer, without leading '<' or trailing '{' */
	    if (uniq) {
	      uniqurl++;
	      nurls[uniqurl] = (char *) malloc(1024, sizeof(char));
	      i = 1;
	      while (i < where-1) {
		nurls[uniqurl][i-1] = (char) buf[i];
		i++;
	      }
	      nurls[uniqurl][i-1] = '\0';
	      printf( " : %s ", nurls[uniqurl]);
	    } else {
	      printf( " : " );
	      for (i =1; i < where-1; i++) putchar(buf[i]);
	      printf( " " );
	    }
	    printf(" }\n"); 
	  } else {
	    printf( " COMMENT url.%d WWWInline { ", ++uniqurl);
	    /* print out buffer, not including initial '<' */
	    for (i =1; i < where; i++) putchar(buf[i]);
	    printf(" }\n"); 
	  }
	} else {
	  /* pass through entire accumulated buffer unchanged */
	  for (i =0; i < where; i++) putchar(buf[i]);
	}
	where = 0; url = 0;
      }
    } else {
      if (c == '{') open++;
      else if (c == '}') {
	open--;
	if (open < balance) {
	  printf(" } ");
	  balance = -1;
	}
      }
      putchar(c);
    }
  }
  if (handle) {
    printf("}})\n");
    for (i = 0; i <= uniqurl; i++) {
      printf(" (emodule-transmit \"weboogl.perl\" \"(NeedURL %s)\n\")\n",nurls[i]);
    }
    printf(" )\n ");
  }
}

      
