#include <QvDB.h>
#include <QvInput.h>
#include <QvNode.h>
#include <QvState.h>
#include <QvToWebOOGL.h>

main(int argc, char **argv)
{
    QvDB::init();

    QvInput	in;
    QvNode	*root;
    char        *handle = NULL;

    if (argc == 2) {
      handle = argv[1];
    } else if (argc > 2) {
      fprintf(stderr, "Usage: vrml2oogl [handle] < vrmlfile > ooglfile\nConvert VRML file into an OOGL file.\nhandle: Return GCL not OOGL, where the OOGL geometry is defined as the handle.\nThe handle generally corresponds to a URL.\n");
      exit(1);
    }
      
    if (!QvDB::read(&in, root) && root != NULL) {
	printf("vrml2oogl: Couldn't parse VRML.\n");
/*	return 1; */
    }


    if (handle) {
      fprintf(stdout, "(progn (read geometry {define \"%s\" {\n", handle);
    }

    QvState state;
    OOGLhandle(handle);
    OOGLfile(stdout);
    root->ToWebOOGL(&state);

    if (handle) {
      int i;
      fprintf(stdout, "}})\n");
      for (i = 0; i < OOGLnumuniq(); i++) {
	fprintf(stdout, 
		" (emodule-transmit \"weboogl.perl\" \"(NeedURL %s)\n\")\n",
		OOGLgeturls(i));
      }
      fprintf(stdout, " )\n ");
    }


    return 0;
}
