/* sos.c --EPM */

/*LINTLIBRARY*/

#include "tools.h"
#include "sos.h"

/* flags */
BOOL SoS_test = FALSE;
BOOL SoS_proto = FALSE;
BOOL SoS_proto_e = FALSE;
BOOL SoS_proto_d = FALSE;

static LIA * SoS_lip;
static INT lastloc;
static INT _n, _d, _len, _lenp;  /* internal SoS_init() parameters */

#define location_of(I,J)  (_lenp * (_d * (I) + (J) - 1))
/* macro to access position in LIA parameter matrix */

/*--------------------------------------------------------------------------*/

PROC SoS_init (n, d, len, lenp)
     IN INT n, d, len, lenp;
     /* initializes SoS package: allocates dynamic array SoS_lip[...] for
        the LIA parameter matrix SoS_lia (i,j), 0 <= i <= n and 1 <= j <= d */
{
  lia_setlength (len);
  _d = d;
  _n = n;
  _len = len;
  _lenp = lenp;
  lastloc = location_of (_n, _d);
  dynamic_dispose (SoS_lip);  /* dispose old matrix, if any */
  dynamic_allocate_0 (SoS_lip, LIA, lastloc + lenp);
  if (not SoS_lip)
    error ("SoS_init: dynamic allocation failed");
#ifdef EBUG
  if (SoS_test)
    print ("SoS: Library compiled with -DEBUG & test flag set.\n");
#endif
  deter ();
  SignDet_one ();
#if 0 /* this is not needed here */
  SignDet ();
#endif
}

/*--------------------------------------------------------------------------*/

INT SoS_n ()
{
  return (_n);
}

/*--------------------------------------------------------------------------*/

INT SoS_d ()
{
  return (_d);
}

/*--------------------------------------------------------------------------*/

LIA * SoS_lia (i, j)
     IN INT i, j;
     /* returns pointer to LIA representation of parameter pi[i,j] */
{
  register INT loc = location_of (i, j);
#ifdef EBUG
  if (SoS_test) if ((i < 0) or (i > _n) or
                    (j < 1) or (j > _d) or
                    (loc < 0) or (loc > lastloc))
    error ("%s(%d,%d) index error: n=%d d=%d lenp=%d len=%d loc=%d lastloc=%d",
           "SoS_lia", i, j, _n, _d, _lenp, _len, loc, lastloc);
#endif
  return (& (SoS_lip[loc]));
}

/*--------------------------------------------------------------------------*/

PROC SoS_param (longi, i, j)
     IN LIA longi[];
     IN INT i, j;
     /* load longi into parameter pi[i,j] */
{
  if (lia_high (longi) > _lenp - 1) 
    error ("SoS_param: LIA parameter too long");
  lia_let (SoS_lia (i, j), longi);
}
