/* smaller.c  --EPM */

#include "tools.h"
#include "sos.h"

/*--------------------------------------------------------------------------*/

BOOL Smaller (i, j, k, l)
     IN INT i, j, k, l;
     /* Smaller predicate; indices in proper range & (i,j) != (k,l) */
{
  register BOOL  result;
#ifdef EBUG
  if (SoS_proto)
    print ("Smaller (%d,%d,%d,%d, %lf (fp), %lf (fp))  ",
           i, j, k, l, lia_real (SoS_lia (i,j)), lia_real (SoS_lia (k,l)));
  if (SoS_test)
    if (not (((i != k) or (j != l)) and (0 <= i) and (i <= SoS_n ()) and
             (0 <= k) and (k <= SoS_n ()) and (1 <= j) and (j <= SoS_d ()) and
             (1 <= l) and (l <= SoS_d ())))
    error ("Smaller: wrong arguments");
#endif
  if (not lia_eq (SoS_lia (i,j), SoS_lia (k,l)))
    result = (lia_le (SoS_lia (i,j), SoS_lia (k,l)));
  else if (i != k)
    result = (i > k);
  else
    result = (j < l);
#ifdef EBUG
  if (SoS_proto)
    print  ("Smaller result: %d\n", result);
#endif
  return (result);
}
