/* signdet_one.c  --EPM */

/*LINTLIBRARY*/

#include "tools.h"
#include "sos.h"

/* workspace */
static LIA * signdet_one_buf; 
static INT li;
#define aux(IND)  &(signdet_one_buf[li * IND])

/*--------------------------------------------------------------------------*/

PROC SignDet_one ()
     /* module initialization */
{
  li = lia_getlength ();
  if (not signdet_one_buf)
    dynamic_allocate_0 (signdet_one_buf, LIA, 17 * li); 
  if (not signdet_one_buf)
    error ("SignDet_one: failed");
}

/*--------------------------------------------------------------------------*/

INT SignDet1one ()
     /* returns always +1 */
{
#ifdef EBUG
  if (SoS_proto_d) print ("SignDet1one = +1\n");
#endif
  return (1);
}

/*--------------------------------------------------------------------------*/

INT SignDet2one (a,
                 e)
     IN LIA a[],  e[];
     /* returns sign of | a 1 |
                        | e 1 | */
{
  lia_sub (aux(0), a, e);
#ifdef EBUG
  if (SoS_proto_d) print ("SignDet2one = %0.0lf (fp)\n", lia_real (aux(0)));
#endif
  return (lia_sign (aux(0)));
}

/*--------------------------------------------------------------------------*/

INT SignDet3one (a, b,
                 e, f,
                 s, t)
     IN LIA a[], b[],  e[], f[],  s[], t[];
     /* returns sign of | a b 1 |
                        | e f 1 |
                        | s t 1 | */
{
  lia_sub (aux(0), e, a);
  lia_sub (aux(1), f, b);
  lia_sub (aux(2), s, a);
  lia_sub (aux(3), t, b);
  deter2 (aux(0), aux(1),
          aux(2), aux(3), aux(4));
#ifdef EBUG
  if (SoS_proto_d) print ("SignDet3one = %0.0lf (fp)\n", lia_real (aux(4)));
#endif
  return (lia_sign (aux(4)));
}

/*--------------------------------------------------------------------------*/

INT SignDet4one (a, b, c,
                 e, f, g,
                 s, t, u,
                 o, p, q)
     IN LIA a[], b[], c[],  e[], f[], g[],  s[], t[], u[],  o[], p[], q[];
     /* returns sign of | a b c 1 |
                        | e f g 1 |
                        | s t u 1 |
                        | o p q 1 | */
{
  lia_sub (aux(0), e, a);   /* 2nd line - 1st line */
  lia_sub (aux(1), f, b);
  lia_sub (aux(2), g, c);
  lia_sub (aux(3), s, a);   /* 3rd line - 1st line */
  lia_sub (aux(4), t, b);
  lia_sub (aux(5), u, c);
  lia_sub (aux(6), o, a);   /* 4th line - 1st line */
  lia_sub (aux(7), p, b);
  lia_sub (aux(8), q, c);
  deter3 (aux(0), aux(1), aux(2),
          aux(3), aux(4), aux(5),
          aux(6), aux(7), aux(8),  aux(9));
  lia_chs (aux(9));
#ifdef EBUG
  if (SoS_proto_d) print ("SignDet4one = %0.0lf (fp)\n", lia_real (aux(9)));
#endif
  return (lia_sign (aux(9)));
}

/*--------------------------------------------------------------------------*/

INT SignDet5one (a, b, c, d,
                 e, f, g, h,
                 s, t, u, v,
                 o, p, q, r,
                 x, y, z, w)
     IN LIA a[], b[], c[], d[],  e[], f[], g[], h[];
     IN LIA s[], t[], u[], v[],  o[], p[], q[], r[];
     IN LIA x[], y[], z[], w[];
     /* returns sign of | a b c d 1 |
                        | e f g h 1 |
                        | s t u v 1 |
                        | o p q r 1 |
                        | x y z w 1 | */
{
  lia_sub (aux(0),  e, a);    /* 2nd line - 1st line */
  lia_sub (aux(1),  f, b);
  lia_sub (aux(2),  g, c);
  lia_sub (aux(3),  h, d);
  lia_sub (aux(4),  s, a);   /* 3rd line - 1st line */
  lia_sub (aux(5),  t, b);
  lia_sub (aux(6),  u, c);
  lia_sub (aux(7),  v, d);
  lia_sub (aux(8),  o, a);   /* 4th line - 1st line */
  lia_sub (aux(9),  p, b);
  lia_sub (aux(10), q, c);
  lia_sub (aux(11), r, d);
  lia_sub (aux(12), x, a);   /* 5th line - 1st line */
  lia_sub (aux(13), y, b);
  lia_sub (aux(14), z, c);
  lia_sub (aux(15), w, d);
  deter4 (aux(0),  aux(1),  aux(2),  aux(3),
          aux(4),  aux(5),  aux(6),  aux(7),
          aux(8),  aux(9),  aux(10), aux(11),
          aux(12), aux(13), aux(14), aux(15), aux(16));
#ifdef EBUG
  if (SoS_proto_d) print ("SignDet5one = %0.0lf (fp)\n", lia_real (aux(16)));
#endif
  return (lia_sign (aux(16)));
}
