/* lia.h: headerfile to lia; needs #include "tools.h" --EPM */

#ifndef LIA_H_SWITCH
#define LIA_H_SWITCH 1

typedef unsigned long int LIA;

PROC lia_setlength();
INT lia_getlength();
PROC lia_counters_output();
PROC lia_reset();

PROC lia_load();
PROC lia_strload();

PROC lia_fput();
REAL lia_real();
CHAR * lia_chars();
#define lia_deci(L)  lia_chars (L, TRUE)
#define lia_hexa(L)  lia_chars (L, FALSE)

PROC lia_let();
PROC lia_chs();
INT lia_sign();
INT lia_high();
LIA lia_digit();

BOOL lia_eq();
BOOL lia_le();
BOOL lia_ple();
BOOL lia_leq();

PROC lia_add();
PROC lia_sub();
PROC lia_mul();

PROC lia_padd();
PROC lia_psub();
PROC lia_sdiv();

PROC lia_div();  /* in file lia2.c */

#endif
