/* lambda5.c --EPM */

#include "tools.h"
#include "sos.h"
#include "depths.h"

depth_counters (Lambda5, 50);

/*--------------------------------------------------------------------------*/

INT SignLambda5 (Ai, Bi, Ci, Di,
                 Aj, Bj, Cj, Dj,
                 Ak, Bk, Ck, Dk,
                 Al, Bl, Cl, Dl,
                 Am, Bm, Cm, Dm)
IN LIA
  Ai[], Bi[], Ci[], Di[],
  Aj[], Bj[], Cj[], Dj[],
  Ak[], Bk[], Ck[], Dk[],
  Al[], Bl[], Cl[], Dl[],
  Am[], Bm[], Cm[], Dm[];
/* computes sign of epsilon determinant Lambda5; generated with gendela
   NOTE: needs modules deter & signdet_one */
{
  the_beginning;
#ifdef EBUG
  if (SoS_proto_e)
    {
      lia_reset ();
      print ("Lambda5 (%s,%s,%s,%s,one;",
             lia_deci (Ai), lia_deci (Bi), lia_deci (Ci), lia_deci (Di));
      print ("%s,%s,%s,%s,one;",
             lia_deci (Aj), lia_deci (Bj), lia_deci (Cj), lia_deci (Dj));
      print ("%s,%s,%s,%s,one;",
             lia_deci (Ak), lia_deci (Bk), lia_deci (Ck), lia_deci (Dk));
      print ("%s,%s,%s,%s,one;",
             lia_deci (Al), lia_deci (Bl), lia_deci (Cl), lia_deci (Dl));
      print ("%s,%s,%s,%s,one)\n",
             lia_deci (Am), lia_deci (Bm), lia_deci (Cm), lia_deci (Dm));
    }
#endif
  /* c code generated by program gendela */
  check;  s =   SignDet5one (Ai,Bi,Ci,Di, Aj,Bj,Cj,Dj, Ak,Bk,Ck,Dk,
                             Al,Bl,Cl,Dl, Am,Bm,Cm,Dm);
  check;  s = - SignDet4one (Aj,Bj,Cj, Ak,Bk,Ck, Al,Bl,Cl, Am,Bm,Cm);
  check;  s =   SignDet4one (Aj,Bj,Dj, Ak,Bk,Dk, Al,Bl,Dl, Am,Bm,Dm);
  check;  s = - SignDet4one (Aj,Cj,Dj, Ak,Ck,Dk, Al,Cl,Dl, Am,Cm,Dm);
  check;  s =   SignDet4one (Bj,Cj,Dj, Bk,Ck,Dk, Bl,Cl,Dl, Bm,Cm,Dm);
  check;  s =   SignDet4one (Ai,Bi,Ci, Ak,Bk,Ck, Al,Bl,Cl, Am,Bm,Cm);
  check;  s =   SignDet3one (Ak,Bk, Al,Bl, Am,Bm);
  check;  s = - SignDet3one (Ak,Ck, Al,Cl, Am,Cm);
  check;  s =   SignDet3one (Bk,Ck, Bl,Cl, Bm,Cm);
  check;  s = - SignDet4one (Ai,Bi,Di, Ak,Bk,Dk, Al,Bl,Dl, Am,Bm,Dm);
  check;  s =   SignDet3one (Ak,Dk, Al,Dl, Am,Dm);
  check;  s = - SignDet3one (Bk,Dk, Bl,Dl, Bm,Dm);
  check;  s =   SignDet4one (Ai,Ci,Di, Ak,Ck,Dk, Al,Cl,Dl, Am,Cm,Dm);
  check;  s =   SignDet3one (Ck,Dk, Cl,Dl, Cm,Dm);
  check;  s = - SignDet4one (Bi,Ci,Di, Bk,Ck,Dk, Bl,Cl,Dl, Bm,Cm,Dm);
  check;  s = - SignDet4one (Ai,Bi,Ci, Aj,Bj,Cj, Al,Bl,Cl, Am,Bm,Cm);
  check;  s = - SignDet3one (Aj,Bj, Al,Bl, Am,Bm);
  check;  s =   SignDet3one (Aj,Cj, Al,Cl, Am,Cm);
  check;  s = - SignDet3one (Bj,Cj, Bl,Cl, Bm,Cm);
  check;  s =   SignDet3one (Ai,Bi, Al,Bl, Am,Bm);
  check;  s = - SignDet2one (Al, Am);
  check;  s =   SignDet2one (Bl, Bm);
  check;  s = - SignDet3one (Ai,Ci, Al,Cl, Am,Cm);
  check;  s = - SignDet2one (Cl, Cm);
  check;  s =   SignDet3one (Bi,Ci, Bl,Cl, Bm,Cm);
  check;  s =   SignDet4one (Ai,Bi,Di, Aj,Bj,Dj, Al,Bl,Dl, Am,Bm,Dm);
  check;  s = - SignDet3one (Aj,Dj, Al,Dl, Am,Dm);
  check;  s =   SignDet3one (Bj,Dj, Bl,Dl, Bm,Dm);
  check;  s =   SignDet3one (Ai,Di, Al,Dl, Am,Dm);
  check;  s =   SignDet2one (Dl, Dm);
  check;  s = - SignDet3one (Bi,Di, Bl,Dl, Bm,Dm);
  check;  s = - SignDet4one (Ai,Ci,Di, Aj,Cj,Dj, Al,Cl,Dl, Am,Cm,Dm);
  check;  s = - SignDet3one (Cj,Dj, Cl,Dl, Cm,Dm);
  check;  s =   SignDet3one (Ci,Di, Cl,Dl, Cm,Dm);
  check;  s =   SignDet4one (Bi,Ci,Di, Bj,Cj,Dj, Bl,Cl,Dl, Bm,Cm,Dm);
  check;  s =   SignDet4one (Ai,Bi,Ci, Aj,Bj,Cj, Ak,Bk,Ck, Am,Bm,Cm);
  check;  s =   SignDet3one (Aj,Bj, Ak,Bk, Am,Bm);
  check;  s = - SignDet3one (Aj,Cj, Ak,Ck, Am,Cm);
  check;  s =   SignDet3one (Bj,Cj, Bk,Ck, Bm,Cm);
  check;  s = - SignDet3one (Ai,Bi, Ak,Bk, Am,Bm);
  check;  s =   SignDet2one (Ak, Am);
  check;  s = - SignDet2one (Bk, Bm);
  check;  s =   SignDet3one (Ai,Ci, Ak,Ck, Am,Cm);
  check;  s =   SignDet2one (Ck, Cm);
  check;  s = - SignDet3one (Bi,Ci, Bk,Ck, Bm,Cm);
  check;  s =   SignDet3one (Ai,Bi, Aj,Bj, Am,Bm);
  check;  s = - SignDet2one (Aj, Am);
  check;  s =   SignDet2one (Bj, Bm);
  check;  s =   SignDet2one (Ai, Am);
  check;  s =   SignDet1one ();
  the_end;
}
