/* isort --- inplace sort routines for very small lists  --EPM */

/*LINTLIBRARY*/

#include "tools.h"

/*--------------------------------------------------------------------------*/

#define swap(A,B) \
do {              \
     aux = A;     \
     A = B;       \
     B = aux;     \
     swaps++;     \
   } once

/*--------------------------------------------------------------------------*/

INT isort2 (a, b)
     IN OUT INT *a, *b;
{
  register INT swaps = 0, aux;
  if (*a > *b)
    swap (*a, *b);
  return (swaps);
}

/*--------------------------------------------------------------------------*/

INT isort3 (a, b, c)
     IN OUT INT *a, *b, *c;
     /* sorts (&a,&b,&c);  <= 3 ifs;  <= 3 swaps */
{
  register INT swaps = 0, aux;
  if (*a > *b)
    swap (*a, *b);
  if (*b > *c)
    {
      swap (*b, *c);
      if (*a > *b)
        swap (*a, *b);
    }
  return (swaps);
}

/*--------------------------------------------------------------------------*/

INT isort4p (a, b, c, d)
     IN OUT INT *a, *b, *c, *d;
     /* sorts (&a,&b,&c,&d) assuming &a < &b < &c;  <= 3 ifs;  <= 3 swaps */
{
  register INT swaps = 0, aux;
  if (*d < *c)
    {
      if (*d < *a)
        {
          swap (*c, *d);
          swap (*b, *c);
          swap (*a, *b);
        }
      else if (*d < *b)
        {
          swap (*c, *d);
          swap (*b, *c);
        }
      else
        swap (*c, *d);
    }
  return (swaps);
}

/*--------------------------------------------------------------------------*/

INT isort4 (a, b, c, d)
     IN OUT INT *a, *b, *c, *d;
     /* sorts (&a,&b,&c,&d);  <= 3+3 ifs;  <= 3+3 swaps (insertion sort) */
{
  register INT swaps = 0, aux;
  /* step1: isort3 */
  if (*a > *b)
    swap (*a, *b);
  if (*b > *c)
    {
      swap (*b, *c);
      if (*a > *b)
        swap (*a, *b);
    }
  /* step2: isort4p */
  if (*d < *c)
    {
      if (*d < *a)
        {
          swap (*c, *d);
          swap (*b, *c);
          swap (*a, *b);
        }
      else if (*d < *b)
        {
          swap (*c, *d);
          swap (*b, *c);
        }
      else
        swap (*c, *d);
    }
  return (swaps);
}

/*--------------------------------------------------------------------------*/

INT isort5p (a, b, c, d, e)
     IN OUT INT *a, *b, *c, *d, *e;
     /* sorts (&a,&b,&c,&d,&e) assuming &a < &b < &c < &d;
        <= 4 ifs;  <= 4 swaps */
{
  register INT swaps = 0, aux;
  if (*e < *d)
    {
      if (*e < *a)
        {
          swap (*d, *e);
          swap (*c, *d);
          swap (*b, *c);
          swap (*a, *b);
        }
      else if (*e < *b)
        {
          swap (*d, *e);
          swap (*c, *d);
          swap (*b, *c);
        }
      else if (*e < *c)
        {
          swap (*d, *e);
          swap (*c, *d);
        }
      else
        swap (*d, *e);
    }
  return (swaps);
}
