/* Program gendela --- to generate tables of relevant terms for Delta-,
                       Lambda-, and Lambda*-type matrices
   -- E.P.Mucke
   - underlying epsilon expansion: eps ^ 2 ^ ((d+1) * i - j + d)
   - key procedure: next_v 
   - see reference \cite{edels:sos}
   - Including: Sign Test !!! (already irrelevant, but still there)
   - USAGE: gendela [-delta] [-lambda] [-star] [-d=<D>]
*/

/*--------------------------------------------------------------------------*/

#include "tools.h"

/*--------------------------------------------------------------------------*/

#define maxlines 37
#define max_d    100
#define max      (max_d + 1)        

BOOL lambda = FALSE, star = FALSE;
BOOL upper_right = FALSE;
INT d;

FILE *code = stdout;

/*--------------------------------------------------------------------------*/

/*ARGSUSED*/ PROC main (argc, argv, envp)
IN INT argc;
IN CHAR *argv[], *envp[];
{
  read_command_line (argc, argv);
  generate ();
}

/*--------------------------------------------------------------------------*/

/*ARGSUSED*/ read_command_line (argc, argv)
IN INT argc;
IN CHAR *argv[];
{
  INT i = 0;
  while (argv[++i])
    {
      if (strcmp (argv[i], "-lambda") == 0)
        lambda = TRUE;
      else if (strcmp (argv[i], "-delta") == 0)
        lambda = FALSE;
      else if (strcmp (argv[i], "-star") == 0)
        star = TRUE;
      else if (strncmp (argv[i], "-d=", 3) == 0)
        (void) sscanf (argv[i], "-d=%d", &d);
      else
        print ("unknown field %s\n", argv[i]);
    }
  if ((not d) or
      (d + 1 > max_d))
    {
      print ("size d not specified or too large\n");
      print ("usage: %s [-lambda] [-star] -d=<size>\n", argv[0]);
      exit (1);
    }
}

/*--------------------------------------------------------------------------*/

generate ()
{
  INT v[max], s, k, i;
  BOOL forget_it, cont;
  upfor (i, 1, d + 1) v[i] = _if (lambda) _then d _else d + 1;
  k = d;
  s = 1;
  show_c_line (k, s, v);
  cont = TRUE;
  while (cont)
    {
      next_v (v);
      k = d;
      s = 1;
      forget_it = FALSE;
      upfor (i, 1, d)
        if (v[i] < v[i+1])
          {
            if (star and (i == 1)) forget_it = TRUE;
            if (odd (i + v[i])) s = -s;
            k--;
          }
      if (not forget_it)
        {
          show_c_line (k, s, v);
          sign_test (v, s);
          if (star)
            cont = not ((k == 1) and upper_right);
          else
            cont = (k > lambda);
        }
    }
}

/*--------------------------------------------------------------------------*/

next_v (v)
INT v[];
{
  INT lambda, kappa;
  lambda = 1;
  while (v[lambda] == 1) lambda++;
  v[lambda] = v[lambda] - 1;
  downfor (kappa, lambda - 1, 1) v[kappa] = v[kappa + 1];
}

/*--------------------------------------------------------------------------*/

sign_test (v, s)
INT v[], s;
{
  INT rw[max], free[max+1], rw1[max];
  INT i, col, to_sort, h, swaps;
  upfor (i, 1, d)
    {
      rw[i] = 0;  free[i] = 1;
    }
  free[d+1] = 1;
  downfor (i, d, 1)
    if (v[i] < v[i+1])
      {
        rw[i] = v[i];  free[v[i]] = 0;
      }
  col = 0;
  upfor (i, 1, d)
    if (not rw[i])
      {
        col ++;  while (not free[col]) col++;
        if (col > d)
          {
            print ("sign_test error: no more rows free.\n");
            exit (1);
          }
        rw [i] = col;
      }
  upfor (i, 1, d) rw1[i] = rw[i];
  swaps = 0;
  do { to_sort = 0;
       upfor (i, 1, d-1) if (rw[i] > rw[i+1])
         {
           h = rw[i];  rw[i] = rw[i+1];  rw[i+1] = h;  to_sort = 1;  swaps++;
         }
     }
  while (to_sort);
  h = swaps mod 2;
  if ((h and (s == 1)) or
      ((not h) and (s == -1)))
    {
      print ("Error: wrong sign!\n");
      print ("from ");
      upfor (i, 1, d) print ("%d ", rw1[i]);
      print ("to ");
      upfor (i, 1, d) print ("%d ", rw[i]);
      print ("in %d swaps\n", swaps);
      exit (1);
    }
}

/*--------------------------------------------------------------------------*/

show_c_line (k, s, v)
INT k, s, v[];
{
  INT i, j, q, k1, k2;
  INT row[max], col[max];
  fprint (code, "check;  s = %c SignDet%d%s (",
           _if (s<0) _then '-' _else ' ', k,
           _if (star) _then "star"
                      _else (_if (lambda) _then "one" _else ""));
  upfor (i, 1, d) row[i] = col[i] = 1;
  upfor (i, 1, d)
    if (v[i] < v[i+1]) row[i] = col[v[i]] = 0;
  k1 = 0;
  upfor (i, 1, d)
   {
     q = 0;
      k2 = 0;
      upfor (j, 1, d)
        if (row[i] and col[j])
          {
            q = 1;
            k2++;
            if (star or (not (lambda and (j == d))))
              {
                print_element (code, i, j);
                if ((lambda and (k > k2 + 1)) or
                    (((not lambda) or star) and (k > k2)) or
                    (k > k1 + 1))
                  fprint (code, ","); 
              }
          }
       if (q) k1++;
       if (q and (k1 != k)) fprint (code, " ");
   } 
   fprint (code, ");\n");
}

/*--------------------------------------------------------------------------*/

print_element (file, i, j)
FILE *file;
INT i, j;
{
  if (star and (i == 1))
    fprint (file, "%c", 'a' - 1 + j);
  else
    fprint (file, "%c%c", 'A' - 1 + j, 'i' - 1 + i);
}
