/* error --- error stop and error hook  --EPM */

/* Note: error_hook() feature NOT supported. */

/* Procedure error (format [, arg] ...) has a variable number of arguments.
   It produces an error_message just like you would do with fprint or vfprint.
   Then it either executes execution or calls a given error hook.

   NOTE that the generated error_message should not be longer than EMLEN 
   characters.  ...  I know, this is ugly, but I don't see an easy way to
   solve it, unless we have dynamic strings AND a sprintf function on them.
   Sounds like a lot of work, but would be very useful.

   To specify an error hook user error_hook (my_error) assuming my_error
   is a pointer to a function:

                       INT my_error (error_message)
                           CHAR error_message[];
                       { ... }

   With this, error() will generate an error message and pass it to
   my_error().  This function might then do some cleanup and/or cause
   a segmentation fault on pupose for dbx.  Use error_hook (NULL) to
   get default behaviour back.
                       
   NOTE that my_error is a pointer to a INT function although its return
   value, if any, will be ignored --- it didn't work with "PROC (* ..) ()". */

/*--------------------------------------------------------------------------*/

#include "tools.h"
#include <varargs.h>  /* Hey, we use variable argument lists! */

#define EMLEN 1000  

static INT (* hook) () = NULL;

/*--------------------------------------------------------------------------*/

/*VARARGS0*/ 
PROC error (va_alist)
     va_dcl
{ /* see headerfile and %man varargs */
  va_list args;
  char *fmt, message[EMLEN];
  va_start (args);
  fmt = va_arg (args, char *);
  (void) vsprintf (message, fmt, args);
  va_end (args);
  if (hook)
    { /* call hook */
      hook (message);
    }
  else
    { /* print error message and stop execution */
      fprint (stderr, message);
      fprint (stderr, "\nExecution terminated.\n");
      exit (1);
    }
}  

/*--------------------------------------------------------------------------*/

#if 0

/* This feature isn't supported in this version.  Sorry. */

PROC error_hook (user_error)
     INT (* user_error) ();
{
  hook = user_error;
}

#endif
