/* dynamic --- encapsulated dynamic memory allocation  --EPM. */

/*LINTLIBRARY*/

/* ????????

   Note:  Do not use the routines defined here, use macros instead.
   Macros defined in tools.h:
   * macro dynamic_allocate(ARRAY,TYPE,SIZE) allocates SIZE elements of type
     TYPE for an dynamic array ARRAY declared as TYPE* ARRAY;
   * macro dynamic_allocate_0(ARRAY,TYPE,SIZE) does the same think but fills
     space with zeros (note: that might take some time, although: bzero() is
     slightly faster than the loop);
   * macro dynamic_dispose(ARRAY) frees the space allocated for ARRAY
     (note: this depends on implementation of free() routine: with standard
     implementation, dynamic_dispose does nothing);
   AND:
   * global variable dynamic_total gives total amount of bytes allocated by
     dynamic_allocate*() not counting disposal;
   * don't use routines dynamic__get() and dynamic__free(): use macros */

/*--------------------------------------------------------------------------*/

#include "tools.h"

#ifdef sgi /* have cool down lint since missing struct in IRIS' malloc.h */
struct arena_s { int whatever; } __whatever;
#endif
#include <malloc.h>

#if __DYNAMIC_DEBUG__   /* which is defined in tools.h */
 static BOOL initialized = FALSE;
 extern malloc_debug(), malloc_verify();
 /* Note: This needs linking with /usr/lib/debug/malloc.o in order to work. */
#endif

#define multiple  4        /* allocates only multiples of this */

/*--------------------------------------------------------------------------*/

static INT
  total_requests = 0,
  new_calls = 0,
  renew_calls = 0;

/*--------------------------------------------------------------------------*/

/*ARGSUSED*/ 
CHAR * dynamic__new (n, initialize0)
     IN unsigned INT n;
     IN BOOL initialize0;
{
  CHAR * space;
  unsigned INT m;
  new_calls ++;
  m = multiple * (n / multiple);
  if ((m == 0) or (m < n)) m += multiple;
#if __DYNAMIC_DEBUG__
  if (not initialized)
    {
      print ("-- dynamic: initializing malloc_debug\n");
      (void) malloc_debug (2);
      initialized = TRUE;
    }
  print ("-- dynamic: %ld+%ld bytes requested\n", n, m - n);
#endif
  space = malloc (m);
  if (not space)
    error ("dynamic: allocation failed\n");
  else if (initialize0)
    bzero (space, (INT) m);  /* initialize space with 0s */
#if __DYNAMIC_DEBUG__
  print ("-- dynamic: allocated, 0x%x ... 0x%x\n", space, &(space[m]));
#endif
  total_requests += m;
  return (space);
}

/*--------------------------------------------------------------------------*/

/*ARGSUSED*/ 
CHAR * dynamic__renew (ptr, n)
     IN CHAR * ptr;
     IN unsigned INT n;
{
  CHAR * space;
  unsigned INT m;
  renew_calls ++;
  m = multiple * (n / multiple);
  if ((m == 0) or (m < n)) m += multiple;
#if __DYNAMIC_DEBUG__
  if ((not initialized) or (ptr == (CHAR *) 0))
    error ("dynamic: invalid re-allocation");
  print ("-- dynamic: %ld+%ld bytes requested (re-allocation of 0x%x)\n",
         n, m - n, ptr);
#endif
  space = realloc (ptr, m);
  if (not space)
    error ("dynamic: re-allocation failed\n");
#if __DYNAMIC_DEBUG__
  print ("-- dynamic: re-allocated, from 0x%x to 0x%x\n", space, &(space[m]));
#endif
  total_requests += m;
  return (space);
}

/*--------------------------------------------------------------------------*/

/*ARGSUSED*/
PROC dynamic__free (ptr)
     IN CHAR * ptr;
{
#if __DYNAMIC_DEBUG__
  print ("-- dynamic: de-allocation of 0x%x\n", ptr);
#endif
  free (ptr);
}

/*--------------------------------------------------------------------------*/

/*ARGSUSED*/
PROC dynamic__remark (macro, array, file, line)
     IN CHAR *macro, *array, *file;
     IN INT line;
{
#if __DYNAMIC_DEBUG__
 print ("%s: for '%s' in file \"%s\" at line %d\n", macro, array, file, line);
#endif  
}

/*--------------------------------------------------------------------------*/

PROC dynamic_info (info, n)
     OUT INT info[];
     IN INT n;
{
  if (n > 0) info[0] = total_requests;
  if (n > 1) info[1] = new_calls;
  if (n > 2) info[2] = renew_calls;
}
