/* deter.c --EPM */

/* All procedures deterI (I=2,3,4) calculate determinants of long integer
   arguments, employing Laplace expansion by the first row.  The procedures
   use long integer arithmetic from module lia. */

#include "tools.h"
#include "sos.h"

static LIA * deter_buf; 
static INT li;
#define aux(IND)  &(deter_buf [li * IND])

/*--------------------------------------------------------------------------*/

PROC deter ()
     /* module initialization */
{
  li = lia_getlength ();
  if (not deter_buf)
    dynamic_allocate_0 (deter_buf, LIA, 10 * li);
  if (not deter_buf)
    error ("deter: failed");
}

/*--------------------------------------------------------------------------*/

PROC deter2 (a, b, 
             c, d, result)
     IN  LIA a[], b[],  c[], d[];
     OUT LIA result[];
{
  lia_mul (aux(0), a, d);
  lia_mul (aux(1), b, c);
  lia_sub (result, aux(0), aux(1));
}

/*--------------------------------------------------------------------------*/

PROC deter3 (a, b, c,
             e, f, g,
             o, p, q, result )
     IN  LIA a[], b[], c[],  e[], f[], g[],  o[], p[], q[];
     OUT LIA result[];
{
  deter2 (f, g,  p, q,  aux(2));
  deter2 (e, g,  o, q,  aux(3));
  deter2 (e, f,  o, p,  aux(4));
  lia_mul (aux(5), a, aux(2));
  lia_mul (aux(2), b, aux(3));
  lia_mul (aux(3), c, aux(4));
  lia_sub (aux(4), aux(5), aux(2));
  lia_add (result, aux(4), aux(3));
}

/*--------------------------------------------------------------------------*/

PROC deter4 (a, b, c, d,
             e, f, g, h,
             o, p, q, r,
             s, t, u, v, result )
     IN  LIA a[], b[], c[], d[],  e[], f[], g[], h[];
     IN  LIA o[], p[], q[], r[],  s[], t[], u[], v[];
     OUT LIA result[];
{
  deter3 (f, g, h,  p, q, r,  t, u, v,  aux(6));
  deter3 (e, g, h,  o, q, r,  s, u, v,  aux(7));
  lia_mul (aux(8), a, aux(6));
  lia_mul (aux(6), b, aux(7));
  lia_sub (aux(7), aux(8), aux(6));
  deter3 (e, f, h,  o, p, r,  s, t, v,  aux(6));
  deter3 (e, f, g,  o, p, q,  s, t, u,  aux(8));
  lia_mul (aux(9), c, aux(6));
  lia_mul (aux(6), d, aux(8));
  lia_sub (aux(8), aux(9), aux(6));
  lia_add (result, aux(7), aux(8));
}
