/* depths.c --EPM */

/*LINTLIBRARY*/

#include "tools.h"
#include "sos.h"

/*--------------------------------------------------------------------------*/

typedef struct clist
{
  /* element of list storing pointers to depth counters */
  CHAR * string;
  INT n;
  INT * c;
  struct clist * next;
} CLIST;

static CLIST * ell = 0;  /* the list of depth counters */

/*--------------------------------------------------------------------------*/

PROC cons_SoS_depths (array, length, text)
     IN INT * array;
     IN INT length;
     IN CHAR * text;
     /* add array to the list of depth counters;
        see the_beginning macro defined in depths.h and used in
        lambda3.c etc */
{
  CLIST * new = (CLIST *) malloc ((unsigned) sizeof (CLIST));
  new->string = text;
  new->n = length;
  new->c = array;
  new->next = ell;
  ell = new;
}

/*--------------------------------------------------------------------------*/

PROC SoS_depths_output (file)
     FILE * file;
     /* prints all non-zero depth counters in list ell: Lambda3() etc */
{
  CLIST * cell = ell;
  INT i, sum0 = 0, sum = 0, max = -1;
  while (cell)
    {
      fprint (file, "* non-zero depth counters for %s\n", cell->string);
      i = 0;
      sum0 += cell->c[0];
      while ((i < cell->n) and (cell->c[i] > 0))
        {
          sum += cell->c[i];
          if (i > max)
            max = i;
          fprint (file, "%12d\n", cell->c[i++]);
        }
      cell = cell->next;
    }
  fprint (file, "* SoS depth counters: summary\n");
  fprint (file, "%12d . max depth\n", max);
  fprint (file, "%12f . mean depth\n",(REAL) sum / (REAL) sum0 - 1.0);
}

/*--------------------------------------------------------------------------*/

PROC SoS_depths_summary (max, mean)
     INT  * max;
     REAL * mean;
     /* like SoS_depth_output but returns only summary values */
{
  CLIST * cell = ell;
  INT i, sum0 = 0, sum = 0;
  *max = -999;
  *mean = -999.999;
  while (cell)
    {
      i = 0;
      sum0 += cell->c[0];
      while ((i < cell->n) and (cell->c[i] > 0))
        {
          sum += cell->c[i];
          if (i > *max)
            *max = i;
        }
      cell = cell->next;
    }
  *mean = (REAL) sum / (REAL) sum0 - 1.0;
}
