#include "ChConst.h"
#include "ChType.h"
#include "ChSoS.h"
#include "incid.h"


PROCEDURE IncCounter (VAR ctr, mctr : INTEGER);
BEGIN
  ctr := ctr + 1;
  IF ctr > mctr THEN
    mctr := ctr;
END;


FUNCTION NewList : LinkPtr;
VAR
  help	: LinkPtr;
BEGIN
  NEW (help);  IncCounter (Links, MLinks);
  help^.next := NIL;  help^.face := NIL;
  NewList := help;
END;


PROCEDURE MakeFace (VAR f : FacePtr);
BEGIN
  NEW (f);  IncCounter (Faces, MFaces);
  f^.color := WHITE;  f^.siteL := NIL;
  f^.subL := NewList;  f^.supL := NewList;
  f^.induc := NIL;
  node := node + 1;
  f^.name := node;
END;


{ ClearInduc NIL's all induc-pointers in a connected graph below f }
PROCEDURE ClearInduc (f : FacePtr);
VAR
  fSubL		: LinkPtr;
BEGIN
  IF f^.induc <> NIL THEN BEGIN
    f^.induc := NIL;
    fSubL := f^.subL;
    WHILE fSubL^.next <> NIL DO BEGIN
      ClearInduc (fSubL^.face);
      fSubL := fSubL^.next;
    END;
  END;
END;


FUNCTION IntAbs (i : INTEGER) : INTEGER;
BEGIN
  IF i >= 0 THEN
    IntAbs := i
  ELSE
    IntAbs := -i;
END;


FUNCTION OtherSite (f : FacePtr) : SiteIndex;
VAR
  s	: SiteIndex;
BEGIN
  s := 1;
  WHILE (s <= D) AND (f^.siteL^[s] = s) DO	{ sites are sorted in siteL }
    s := s + 1;
  OtherSite := s;
END;


PROCEDURE PrintList (l : LinkPtr);
BEGIN
  WHILE l^.next <> NIL DO BEGIN
    write (OutFile, IntAbs(l^.face^.name):5); flush;
    l := l^.next;
  END;
  writeln (OutFile);
END;


PROCEDURE PrintnMarkFaces (f : FacePtr; l : INTEGER);
VAR
  fSubL		: LinkPtr;
  i		: INTEGER;
BEGIN
  IF f^.name > 0 THEN BEGIN
    write (OutFile, 'Node ', f^.name:4, '  Level : ', l:4,
      '  Color : ', ORD (f^.color));
    IF f^.induc <> NIL THEN
      write (OutFile, '  Induc : ', f^.induc^.name);
    writeln (OutFile);

    write (OutFile, '  contained in : ');
    PrintList (f^.supL);

    write (OutFile, '  contains     : ');
    PrintList (f^.subL);

    IF l = D - 1 THEN BEGIN
      write (OutFile, '  sites        : ');
      FOR i := 1 TO D DO
        write (OutFile, Sind[f^.siteL^[i]]:4);
      writeln (OutFile);
    END;

    f^.name := -f^.name;
    fSubL := f^.subL;
    WHILE fSubL^.next <> NIL DO BEGIN
      PrintnMarkFaces (fSubL^.face, l-1);
      fSubL := fSubL^.next;
    END;
  END;
END;


PROCEDURE UnmarkFaces (f : FacePtr);
VAR
  fSubL		: LinkPtr;
BEGIN
  IF f^.name < 0 THEN BEGIN
    f^.name := -f^.name;
    fSubL := f^.subL;
    WHILE fSubL^.next <> NIL DO BEGIN
      UnmarkFaces (fSubL^.face);
      fSubL := fSubL^.next;
    END;
  END;
END;


PROCEDURE PrintFaces;	{(f : FacePtr; l : INTEGER)}
BEGIN
  PrintnMarkFaces (f, l);
  UnmarkFaces (f);
END;


PROCEDURE PrintFacets;	{(f : FacePtr)}
VAR
  fsubL		: LinkPtr;
  i		: DimType;
BEGIN
  fsubL := f^.subL;
  WHILE fsubL^.next <> NIL DO BEGIN
    FOR i := 1 TO D DO 
      write (OutFile, Sind[fsubL^.face^.siteL^[i]]:5);
    writeln (OutFile);
    fsubL := fsubL^.next;
  END;
END;


PROCEDURE PrintLowFacets;	{(f : FacePtr)}
VAR
  fsubL		: LinkPtr;
  i		: DimType;
  s		: SiteIndex;
  g		: FacePtr;
  gsiteL	: SiteListPtr;
BEGIN
  fsubL := f^.subL;
  WHILE fsubL^.next <> NIL DO BEGIN
    g := fsubL^.face;
    gsiteL := g^.siteL;
    s := OtherSite (g);
    IF ChAbove (gsiteL, s) THEN BEGIN
      FOR i := 1 TO D DO 
        write (OutFile, Sind[gsiteL^[i]]:5);
      writeln (OutFile);
    END;
    fsubL := fsubL^.next;
  END;
END;


PROCEDURE PrintUpFacets;	{(f : FacePtr)}
VAR
  fsubL		: LinkPtr;
  i		: DimType;
  s		: SiteIndex;
  g		: FacePtr;
  gsiteL	: SiteListPtr;
BEGIN
  fsubL := f^.subL;
  WHILE fsubL^.next <> NIL DO BEGIN
    g := fsubL^.face;
    gsiteL := g^.siteL;
    s := OtherSite (g);
    IF NOT ChAbove (gsiteL, s) THEN BEGIN
      FOR i := 1 TO D DO 
        write (OutFile, Sind[gsiteL^[i]]:5);
      writeln (OutFile);
    END;
    fsubL := fsubL^.next;
  END;
END;


PROCEDURE PrintnMarkGraph (f : FacePtr; l : INTEGER);
VAR
  fSubL		: LinkPtr;
  i		: INTEGER;
BEGIN
  IF f^.name > 0 THEN BEGIN
    writeln (OutFile, f^.name:5, l:3);
    PrintList (f^.supL);
    PrintList (f^.subL);
    IF l = D - 1 THEN BEGIN
      FOR i := 1 TO D DO
        write (OutFile, Sind[f^.siteL^[i]]:4);
      writeln (OutFile);
    END;
    writeln (OutFile);
    f^.name := -f^.name;
    fSubL := f^.subL;
    WHILE fSubL^.next <> NIL DO BEGIN
      PrintnMarkGraph (fSubL^.face, l-1);
      fSubL := fSubL^.next;
    END;
  END;
END;


PROCEDURE PrintGraph;	{(f : FacePtr; l : INTEGER)}
BEGIN
  PrintnMarkGraph (f, l);
  UnmarkFaces (f);
END;


PROCEDURE DisposeList (VAR l : LinkPtr);
VAR
  help	: LinkPtr;
BEGIN
  WHILE l <> NIL DO BEGIN
    help := l;
    l := l^.next;
    DISPOSE (help);  Links := Links - 1;
  END;
END;


PROCEDURE AddLink (f : FacePtr; VAR l : LinkPtr);
VAR
  help	: LinkPtr;
BEGIN
  NEW (help);  IncCounter (Links, MLinks);
  help^.next := l;
  help^.face := f;
  l := help;
END;


PROCEDURE AddIncid (sub, sup : FacePtr);
BEGIN
  AddLink (sup, sub^.supL);
  AddLink (sub, sup^.subL);
END;


FUNCTION Duplicate (g : FacePtr) : FacePtr;
VAR
  f, gSub	: FacePtr;
  gSubL		: LinkPtr;
BEGIN
  IF g^.induc = NIL THEN BEGIN
    MakeFace (f);
    { writeln ('duplicate (f, g) : ', f^.name, g^.name); }
    g^.induc := f;
    AddIncid (g, f);
    gSubL := g^.subL;
    WHILE gSubL^.next <> NIL DO BEGIN
      gSub := gSubL^.face;
      g := Duplicate (gSub);
      AddIncid (g, f);
      gSubL := gSubL^.next;
    END;
    Duplicate := f;
    { writeln ('  duplicate (f, g) : ', f^.name, g^.name); }
  END
  ELSE
    Duplicate := g^.induc;
END;


PROCEDURE InitSiteL (f : FacePtr);
VAR
  facetL	: LinkPtr;
  facet		: FacePtr;
  i, j		: INTEGER;
  s		: SiteIndex;
BEGIN
  facetL := f^.subL;
  i := D + 1;
  WHILE i > 0 DO BEGIN
    facet := facetL^.face;
    NEW (facet^.siteL);  IncCounter (Facets, MFacets);
    j := 1;
    FOR s := 1 TO D + 1 DO
      IF s <> i THEN BEGIN
        facet^.siteL^[j] := s;
        j := j + 1;
      END;
    i := i - 1;
    facetL := facetL^.next;
  END;
END;


PROCEDURE InitReds (f : FacePtr; VAR MaybeRed : LinkPtr);
VAR
  facetL	: LinkPtr;
BEGIN
  facetL := f^.subL;
  WHILE facetL^.next <> NIL DO BEGIN
    AddLink (facetL^.face, MaybeRed);
    facetL := facetL^.next;
  END;
END;


PROCEDURE MakeDSimplex;	{(VAR TopNode : FacePtr; VAR MaybeRed : LinkPtr)}
VAR
  NewTop	: FacePtr;
  i		: INTEGER;
BEGIN
  node := 0;
  MakeFace (TopNode);
  FOR i := 0 TO D DO BEGIN
    NewTop := Duplicate (TopNode);
    ClearInduc (TopNode);
    TopNode := NewTop;
  END;
  InitSiteL (TopNode);
  MaybeRed := NewList;
  InitReds (TopNode, MaybeRed);
END;


FUNCTION FindColor (f : FacePtr; s : SiteIndex) : FaceColor;
VAR
  q		: SiteIndex;
  fsiteL	: SiteListPtr;
BEGIN
  q := OtherSite (f);	{ f must be a facet }
  fsiteL := f^.siteL;
  IF ChAbove (fsiteL, s) <> ChAbove (fsiteL, q) THEN
    FindColor := RED
  ELSE
    FindColor := BLUE;
END;


FUNCTION OtherSup (sub, sup : FacePtr) : FacePtr;  { sup has to be a facet }
VAR
  help	: LinkPtr;
BEGIN
  help := sub^.supL;
  IF help^.face = sup THEN
    OtherSup := help^.next^.face
  ELSE
    OtherSup := help^.face;
END;


FUNCTION SubColor (f, g : FacePtr) : FaceColor;
BEGIN
  IF f^.color = g^.color THEN
    SubColor := f^.color
  ELSE
    SubColor := PURPLE;
END;


PROCEDURE FindReds (f : FacePtr; s : SiteIndex);
VAR
  fsubL		: LinkPtr;
  e, g		: FacePtr;
BEGIN
  AddLink (f, List[D-1]);
  f^.color := FindColor (f, s);
  {d writeln ('FindRed: Coloring face ', f^.name:4, ORD (f^.color)); d}
  IF f^.color <> BLUE THEN BEGIN
    fsubL := f^.subL;
    WHILE fsubL^.next <> NIL DO BEGIN
      e := fsubL^.face;
      g := OtherSup (e, f);
      IF g^.color = WHITE THEN
        FindReds (g, s);
      IF e^.color = WHITE THEN BEGIN
        AddLink (e, List[D-2]);
        e^.color := SubColor (f, g);
      END;
      fsubL := fsubL^.next;
    END;
  END;
END;


PROCEDURE FindNonBlue;
VAR
  i		: ListIndex;
  Listi1, fsubL	: LinkPtr;
  f, e		: FacePtr;
BEGIN
  FOR i := D - 3 DOWNTO -1 DO BEGIN
    Listi1 := List[i+1];
    WHILE Listi1^.next <> NIL DO BEGIN
      f := Listi1^.face;
      fsubL := f^.subL;
      WHILE fsubL^.next <> NIL DO BEGIN
        e := fsubL^.face;
        IF e^.color = WHITE THEN BEGIN
          e^.color := PURPLE;
          AddLink (e, List[i]);
        END;
        fsubL := fsubL^.next;
      END;
      Listi1 := Listi1^.next;
    END;
  END;
END;


PROCEDURE PrintLists;
VAR
  i	: ListIndex;
BEGIN
  FOR i := -1 TO D-1 DO BEGIN
    write (OutFile, 'L[', i:2, '] : ');
    PrintList (List[i]);
  END;
END;


PROCEDURE Coloring (MaybeRed : LinkPtr; s : SiteIndex);
VAR
  f		: FacePtr;
BEGIN
  WHILE FindColor (MaybeRed^.face, s) <> RED DO
    MaybeRed := MaybeRed^.next;
  f := MaybeRed^.face;	{ f is a red face }
  FindReds (f, s);		{ color all red faces }
  FindNonBlue;
  {d PrintLists; d}
END;


PROCEDURE InitLists;
VAR
  i	: ListIndex;
BEGIN
  FOR i := -1 TO D DO
    List[i] := NewList;
END;


{ FindHyper determines the hyperplane through s and the intersection of }
{ facets g and h.  The hyperplane is stored in facet f.			}
PROCEDURE FindHyper (f, g, h : FacePtr; s : SiteIndex);
VAR
  gSites, hSites	: SiteListPtr;
  i, j, k		: INTEGER;
BEGIN
  gSites := g^.siteL;
  hSites := h^.siteL;
  NEW (f^.siteL);  IncCounter (Facets, MFacets);
  i := 1;  j := 1;  k := 1;
  WHILE k < D DO BEGIN
    IF gSites^[i] = hSites^[j] THEN BEGIN
      f^.siteL^[k] := gSites^[i];
      k := k + 1;  i := i + 1;  j := j + 1;
    END
    ELSE
      IF gSites^[i] < hSites^[j] THEN
        i := i + 1
      ELSE
        j := j + 1;
  END;
  f^.siteL^[D] := s;
END;


PROCEDURE RemOfList (l : LinkPtr);
VAR
  help	: LinkPtr;
BEGIN
  help := l^.next;
  l^.face := help^.face;
  l^.next := help^.next;
  DISPOSE (help);  Links := Links - 1;
END;


FUNCTION LocateLink (f : FacePtr; l : LinkPtr) : LinkPtr;
BEGIN
  WHILE l^.face <> f DO
    l := l^.next;
  LocateLink := l;
END;


PROCEDURE RemoveFace (f : FacePtr);
VAR
  fsupL, fsubL, fLink	: LinkPtr;
BEGIN
  {d writeln ('RemoveFace ', f^.name); d}
  fsupL := f^.supL;
  WHILE fsupL^.next <> NIL DO BEGIN
    {d writeln ('  Locate ', f^.name, ' in ', fsupL^.face^.name); d}
    fLink := LocateLink (f, fsupL^.face^.subL);
    RemOfList (fLink);
    fsupL := fsupL^.next;
  END;
  fsubL := f^.subL;
  WHILE fsubL^.next <> NIL DO BEGIN
    fLink := LocateLink (f, fsubL^.face^.supL);
    RemOfList (fLink);
    fsubL := fsubL^.next;
  END;
  IF f^.siteL <> NIL THEN BEGIN
    DISPOSE (f^.siteL);  Facets := Facets - 1;
  END;
  DisposeList (f^.supL);
  DisposeList (f^.subL);
  DISPOSE (f);  Faces := Faces - 1;
END;


PROCEDURE Update (TopNode : FacePtr; VAR MaybeRed : LinkPtr; s : SiteIndex);
VAR
  i			: ListIndex;
  Listi, fsubL		: LinkPtr;
  f, fInduc, 
  fsup1, fsup2, e	: FacePtr;
BEGIN
  FOR i := -1 TO D-1 DO BEGIN
    Listi := List[i];
    WHILE Listi^.next <> NIL DO BEGIN
      f := Listi^.face;
      CASE f^.color OF
        WHITE: 
          writeln ('SIGH: white face ', f^.name:4, ' in list ', i:3);
        PURPLE: BEGIN
          MakeFace (fInduc);
          f^.induc := fInduc;
          IF i = D-2 THEN BEGIN
            AddLink (fInduc, MaybeRed);
            fsup1 := f^.supL^.face;
            fsup2 := f^.supL^.next^.face;
            FindHyper (fInduc, fsup1, fsup2, s);
            AddIncid (fInduc, TopNode);
          END;
          AddIncid (f, fInduc);
          fsubL := f^.subL;
          WHILE fsubL^.next <> NIL DO BEGIN
            e := fsubL^.face;
            IF e^.induc <> NIL THEN
              AddIncid (e^.induc, fInduc);
            fsubL := fsubL^.next;
          END;
          Listi := Listi^.next;
        END{PURPLE};

        RED: BEGIN
          RemOfList (Listi);	{ remove face f from List[i] }
          RemoveFace (f);
        END;

        BLUE:
          Listi := Listi^.next;
      END{CASE};
    END;
  END;
END;


PROCEDURE ClearList (l : LinkPtr);
VAR
  f	: FacePtr;
BEGIN
  WHILE l^.next <> NIL DO BEGIN
    f := l^.face;
    f^.color := WHITE;
    f^.induc := NIL;
    l := l^.next;
  END;
END;


PROCEDURE ClearLists;
VAR
  i	: ListIndex;
BEGIN
  FOR i := -1 TO D-1 DO BEGIN
    ClearList (List[i]);
    DisposeList (List[i]);
  END;
END;


PROCEDURE Increment;	{(TopNode : FacePtr;
			VAR MaybeRed : LinkPtr;
			s : SiteIndex)}
BEGIN
  {d write (OutFile, 'MaybeRed : ');  PrintList (MaybeRed); d}
  InitLists;
  Coloring (MaybeRed, s);
  DisposeList (MaybeRed);  MaybeRed := NewList;
  Update (TopNode, MaybeRed, s);
  {d PrintLists; d}
  ClearLists;
END;


FUNCTION InSiteL (i : SiteIndex; sL : SiteListPtr) : BOOLEAN;
VAR
  s	: SiteIndex;
BEGIN
  s := 1;
  WHILE (s <= D) AND (sL^[s] <> i) DO	{ sites are sorted in siteL }
    s := s + 1;
  InSiteL := (s <= D);
END;


PROCEDURE CheckHull;	{(TopNode : FacePtr; n : SiteIndex)}
VAR
  f		: FacePtr;
  fsubL		: LinkPtr;
  fsiteL	: SiteListPtr;
  i, s		: SiteIndex;
  side		: BOOLEAN;
BEGIN
  fsubL := TopNode^.subL;
  WHILE fsubL^.next <> NIL DO BEGIN
    f := fsubL^.face;
    fsiteL := f^.siteL;
    s := OtherSite (f);
    side := ChAbove (fsiteL, s);
    FOR i := 1 TO n DO
      IF NOT InSiteL (i, fsiteL) AND (ChAbove (fsiteL, i) <> side) THEN
        writeln ('SIGH : facet ', f^.name:4, ' separates sites ',
          s:4, ' and ', i:4);
    fsubL := fsubL^.next;
  END;
END;
