{ CH  --  d - dimensional convex hull			harald rosenberger }
{ 
  Options:
    a	: Show results of calls to ChAbove.
    c	: Check convex hull.
    f	: Display information about the facets only.
    g	: Display all the information in the incidence structure relevant
	  to the convex hull (a subset of i).
    i	: Display incidence structure after construction of hull.
    l	: Display only facets on lower part of the hull.
    r	: Display information about memory and time consumption.
    s	: Display sorted list of sites with original indices.
    t	: Trace execution (adding points, etc).
    u	: Display only facets on upper part of the hull.
}
PROGRAM CH (input, output);

#include "ChConst.h"
#include "ChType.h"
#include "ChSoS.h"
#include "ChOptions.h"
#include "heap.h"
#include "incid.h"
#include "utime.h"

VAR
  TopNode		: FacePtr;
  n			: INTEGER;
  s			: SiteIndex;
  InName, OutName	: String;


PROCEDURE Concat (s1, s2 : String; VAR s3 : String);
VAR
  i1, i2, l3	: INTEGER;
BEGIN
  l3 := LENGTH (s3);
  i1 := 1;
  WHILE (s1[i1] <> ' ') AND (i1 < l3) DO BEGIN
    s3[i1] := s1[i1];
    i1 := i1 + 1;
  END;
  i2 := 1;
  WHILE (s2[i2] <> ' ') AND (i1 < l3) DO BEGIN
    s3[i1] := s2[i2];
    i1 := i1 + 1;
    i2 := i2 + 1;
  END;
  s3[i1] := CHR (0);
END;


PROCEDURE ReadData (VAR n : INTEGER);
VAR
  i	: DimType;
BEGIN
  n := 0;
  WHILE (NOT EOF (input)) AND (n < MaxSites) DO BEGIN
    n := n + 1;
    FOR i := 1 TO D DO
      read (Site[n][i]);
    readln;
  END;
END;


PROCEDURE DataToSoS (n : INTEGER);
VAR
  i	: SiteIndex;
  j	: DimType;
BEGIN
  FOR i := 1 TO n DO
    FOR j := 1 TO D DO
      ChSoSLoad (i, j, Site[i][j]);
END;


PROCEDURE SortSites (n : INTEGER);
VAR
  i	: INTEGER;
BEGIN
  FOR i := 1 TO n DO
    Insert (i);
  FOR i := 1 TO n DO 
    Sind[i] := Remove (1);	{ index of smallest site }
END;

PROCEDURE PrintSites (n : INTEGER);
VAR
  i	: INTEGER;
  j	: DimType;
BEGIN
  FOR i := 1 TO n DO BEGIN
    write (Sind[i]:5, ' : ');
    FOR j := 1 TO D DO
      write (Site[Sind[i]][j]:11);
    writeln;
  END;
END;


BEGIN {main}
  writeln (D:1, 'D Convex Hull  (V1.3 Pascal SoS)  Feb 18, 1990');
  GetOptions (Option, inf, outf);
  IF inf[1] = '*' THEN BEGIN
    writeln ('Usage: ch',D:1,' [options] sitefile [outfile]');
    HALT;
  END;

  Concat (inf, '.sites', InName);
  reset (input, InName);
  ReadData (n);
  writeln (n:1, ' sites accepted from ', InName, '.');
  IF n <= D THEN BEGIN
    writeln ('CH', D:1, ' needs at least ', (D+1):1, ' sites.');
    HALT;
  END;

  IF outf[1] <> '*' THEN
    rewrite (output, outf);

  Faces := 0;  MFaces := 0;
  Facets := 0;  MFacets := 0;
  Links := 0;  MLinks := 0;

  ChSoSInit (n);
  DataToSoS (n);

  HeapSize := 0;
  SortSites (n);

  IF Option['s'] THEN PrintSites (n);

  MakeDSimplex (TopNode, MaybeRed);
  IF Option['t'] THEN
    FOR s := 1 TO D + 1 DO
      write ('.');
  FOR s := D + 2 TO n DO BEGIN
    IF Option['t'] THEN write ('.');  flush;
    Increment (TopNode, MaybeRed, s);
  END;
  IF Option['t'] THEN writeln;
  IF Option['c'] THEN BEGIN
    writeln ('checking hull ...');
    CheckHull (TopNode, n);
  END;
  IF Option['r'] THEN BEGIN
    writeln ('Allocated cells:  finally  maximum  (for ', n:1, ' sites)');
    writeln ('Faces          ', Faces:9, MFaces:9);
    writeln ('Facets         ', Facets:9, MFacets:9);
    writeln ('Links          ', Links:9, MLinks:9);
    writeln ('Elapsed time: ', UserTime:1, ' seconds.');
  END;
  IF Option['i'] THEN BEGIN
    Concat (inf, '.longgraph', OutName);
    rewrite (OutFile, OutName);
    PrintFaces (TopNode, D);
    writeln ('Wrote extended incidence graph to ', OutName, '.');
  END;
  IF Option['f'] THEN BEGIN
    Concat (inf, '.facets', OutName);
    rewrite (OutFile, OutName);
    PrintFacets (TopNode);
    writeln ('Wrote facets to ', OutName, '.');
  END;
  IF Option['l'] THEN BEGIN
    Concat (inf, '.lowhull', OutName);
    rewrite (OutFile, OutName);
    PrintLowFacets (TopNode);
    writeln ('Wrote facets on lower hull to ', OutName, '.');
  END;
  IF Option['u'] THEN BEGIN
    Concat (inf, '.uphull', OutName);
    rewrite (OutFile, OutName);
    PrintUpFacets (TopNode);
    writeln ('Wrote facets on upper hull to ', OutName, '.');
  END;
  IF Option['g'] THEN BEGIN
    Concat (inf, '.graph', OutName);
    rewrite (OutFile, OutName);
    PrintGraph (TopNode, D);
    writeln ('Wrote incidence graph to ', OutName, '.');
  END;
END.
