#include "ChConst.h"
#include "ChType.h"
#include "heap.h"
#include "ChSoS.h"


PROCEDURE MoveLink;
BEGIN
  HeapLink[New] := HeapLink[Old];
  TheHeap[HeapLink[New]] := New;
END;


PROCEDURE Swap (Upper, Lower : INTEGER);
VAR
  Help		: INTEGER;
BEGIN
  Help			:= TheHeap[Lower];
  TheHeap[Lower]	:= TheHeap[Upper];
  TheHeap[Upper]	:= Help;
  HeapLink[TheHeap[Lower]] := Lower;
  HeapLink[TheHeap[Upper]] := Upper;
END;


PROCEDURE TrickleDown (HeapPos : INTEGER);
VAR
  MinPos	: INTEGER;
BEGIN
  WHILE HeapPos <= HeapSize DIV 2 DO
    IF 2 * HeapPos = HeapSize THEN BEGIN
      IF Smaller (TheHeap[HeapSize], TheHeap[HeapPos]) THEN
	Swap (HeapPos, HeapSize);
      HeapPos := HeapSize;
    END
    ELSE BEGIN
      IF Smaller (TheHeap[2 * HeapPos], TheHeap[2 * HeapPos + 1]) THEN 
	MinPos := 2 * HeapPos
      ELSE
	MinPos := 2 * HeapPos + 1;

      IF Smaller (TheHeap[MinPos], TheHeap[HeapPos]) THEN BEGIN
	Swap (HeapPos, MinPos);
	HeapPos := MinPos
      END
      ELSE
	HeapPos := HeapSize
    END
END;


PROCEDURE TrickleUp (HeapPos : INTEGER);
BEGIN
  WHILE HeapPos <> 1 DO
    IF Smaller (TheHeap[HeapPos], TheHeap[HeapPos DIV 2]) THEN BEGIN
      Swap (HeapPos DIV 2, HeapPos);
      HeapPos := HeapPos DIV 2
    END
    ELSE
      HeapPos := 1
END;


PROCEDURE Replace (HeapPos, Element : INTEGER);
BEGIN
  TheHeap[HeapPos]	:= Element;
  HeapLink[Element]	:= HeapPos;
  TrickleUp (HeapPos);
  TrickleDown (HeapPos);
END;


PROCEDURE Insert;
BEGIN
  HeapSize := HeapSize + 1;
  Replace (HeapSize, Element);
END;


FUNCTION Remove;
VAR
  Old		: INTEGER;
BEGIN
  Old := TheHeap[HeapPos];
  HeapSize := Heapsize - 1;
  Replace (HeapPos, TheHeap[HeapSize + 1]);
  Remove := Old;
END;
