/* sos/lambda3.c */

/*--------------------------------------------------------------------------*/

#include "basic.h"
#include "sos.h"
#include "internal.h"
#include "primitive.h"

/*--------------------------------------------------------------------------*/

Static_Declarations ("lambda3", 3, 14, 2);

#include "primitive.i.c"

/*--------------------------------------------------------------------------*/

SoS_primitive_result* sos_lambda3 (int i, int j, int k)
     /* Returns significant term of Lambda3 epsilon-determinant.
        Assumes indices in proper range, pairwise different, and sorted. */
{
#ifdef __DEBUG__
  if (sos_proto_e_flag)
    {
      lia_clear ();
      print ("sos_lambda3 (%d,%d,%d)", i, j, k);
      print (" (");
      print ("%s,%s,1;", Pi(i,1), Pi(i,2));
      print ("%s,%s,1;", Pi(j,1), Pi(j,2));
      print ("%s,%s,1;", Pi(k,1), Pi(k,2));
      print (")\n");
    }
#endif
/* C code generated by 'ccode' from 'gee' file "Lambda3.out" */
Initialize ();
Epsilon_Term (0);
Positive_Coefficient (Minor3 (i, j, k, 1, 2, 0));
Epsilon_Term (1);
Epsilon (i,2);
Negative_Coefficient (Minor2 (j, k, 1, 0));
Epsilon_Term (2);
Epsilon (i,1);
Positive_Coefficient (Minor2 (j, k, 2, 0));
Epsilon_Term (3);
Epsilon (j,2);
Positive_Coefficient (Minor2 (i, k, 1, 0));
Epsilon_Term (4);
Epsilon (j,2);
Epsilon (i,1);
Coefficient (Integer (1));
Finish ();
}
