#!/usr/local/bin/perl
#
# to-weboogl.perl
#
# Mosaic external viewer for OOGL (and WebOOGL) files.  To use, add
# the following line to your .mailcap file or the system mailcap:
#
#	object/x-oogl; to-weboogl.perl %s
#
# This script merely ships OOGL data to the real weboogl.perl script,
# which runs as an external module under Geomview.  The purpose of
# this script is to keep communications going between the same copy
# of Geomview and Mosaic throughout the session.

# Configure for your local system:
$geomview_cmd = 'geomview';

# We link the file to a safe location, and then tell weboogl
# where to find it by putting the filename into a special
# request file (indexed by Mosaic's pid), and then sending
# weboogl a signal.
#
# If the control file containing weboogl's pid doesn't yet exist,
# we start up a new copy of weboogl, and just tell it the filename
# directly.
#
# In either case, the weboogl script will delete the raw data file.
#
# This script relies on having Mosaic's process group id be equal
# to its process id.  This is normally the case when Mosaic is
# started from a shell, and is also upheld by the weboogl
# script whenever it starts up a copy of Mosaic itself.

select(STDERR); $| = 1;
select (STDOUT); $| = 1;
$mosaic_pid = getpgrp(0);
$tmpfile = ("/tmp/$mosaic_pid." . time . ".weboogl");
$pid_file = "/tmp/to-WebOOGL.$mosaic_pid";
$comm_file = "/tmp/WebOOGL.$mosaic_pid";

# Copy data to safe place.
if(0 != system("cp $ARGV[0] $tmpfile")) {
	die("Failed to copy $ARGV[0] to $tmpfile\n");
}
$contype = $ARGV[1];
$baseurl = $ARGV[3] if ($ARGV[2] =~ /URL/);

# Try to communicate with weboogl.perl.
if(!open(CONTROL, "<$pid_file") || (($weboogl_pid = <CONTROL>) <= 0)) {

	# Cannot find a copy of weboogl.perl associated to us,
	# so start up a new copy.
	if( fork() == 0 ) {
		exec("$geomview_cmd -run weboogl.perl $mosaic_pid $tmpfile $contype $baseurl");
	}

} else {

	# Send interrupt request to weboogl.perl.
	open(REQUEST, ">$comm_file");
	print REQUEST "$tmpfile\n";
	close(REQUEST);
	kill('INT', $weboogl_pid);

	# Make sure weboogl.perl received it; if not, start up a new copy.
	sleep(7);
	if(-e $comm_file) {
		unlink($comm_file);
		unlink($pid_file);
		if( fork() == 0 ) {
			exec("$geomview_cmd -run weboogl.perl $mosaic_pid $tmpfile $contype $baseurl");
		}
	}

}
exit(0);


