#!/usr/local/bin/perl
# ==========================================================================
# Download URL to local file.
# If it's a 3D type (VRML or WebOOGL) convert to OOGL using
# vrml2oogl or woogl2oogl, pass it to Geomview. 
# Else pass it along to 2D Web browser. 
#
# by Tamara Munzner 1995
#
# Distributed under the GNU Public License
#
# Depends on woogl2oogl, vrml2oogl, libwww-perl.
# <http://www.ics.uci.edu/WebSoft/libwww-perl/>
# Derived from Roy Fielding's "get".
# ==========================================================================
#
# INSTALLATION
#
# If perl is installed in a different place than "/usr/local/bin", then
# change the first line in this file.
# $LIBWWW should point to the location of the libwww-perl library
# on your system. 
# $LOCALLIB should point to the main perl libraries on your system,
# i.e. the location of files like "sys/socket.ph".
# Note that the environment variable "LIBWWW_PERL", if set, overrides the 
# hardwired string.
#
   $LIBWWW = "/usr/local/lib/libwww-perl-0.40";
   $LOCALLIB = "/usr/local/lib/perl";
#
########################################################################

$SHELL = "/bin/sh";
unshift(@INC, $LIBWWW, $LOCALLIB);
if ($libloc = $ENV{'LIBWWW_PERL'}) { unshift(@INC, $libloc); }

require "www.pl";
require "wwwurl.pl";
require "wwwerror.pl";

$method = "GET";
$Version = "gvgeturl/WebOOGL 2.0";

# Set up User-Agent: header
&www'set_def_header('http', 'User-Agent', $Version);

# Time-out in seconds
$Tout    = 30;                                    

# ==========================================================================
# Get the command-line options
# Usage: getgvurl url handle browser_pid [-base baseURL]
# url = url to get, doubles as Geomview handle name
# browser_pid = ID of 2D Web browser, presumably netscape or mosaic
# baseURL = optional base URL, lets us handle relative URLs. 
# contype = content type 
#   (information stripped by 2D browser downloading URL to local file,
#    regained from parameter specified in mailcap according to type)

$handle = $ARGV[0];
$browser_pid = $ARGV[1];
shift; shift;
while (@ARGV[0]) {
$Base = $ARGV[1] if $ARGV[0] eq "-base";
$Contype = $ARGV[1] if $ARGV[0] eq "-contype";
shift;shift;
}

# ==========================================================================
# Do the work

$url = &wwwurl'absolute($Base, $handle);
&do_req($method, $url);
exit(0);

#-----------------------------------------------------------------
sub do_req
{
    local($method, $url) = @_;
    local($hd, $response);

    local(%headers) = ();
    local($headers) = '';
    local($content) = '';
    local(*CONVERT);
    local($tmpfile) = "/tmp/www.$$";
    $response = &www'request($method, $url, *headers, *content, $Tout);
#   print STDERR "method is $method, url is $url, reponse is $response\n";
    $type = $headers{'content-type'};
    # vrml or oogl is legitimate. plain/text might be a lie 
    # if headers were stripped.
    $type = $Contype unless ($type =~ /oogl/ || $type =~ /vrml/);
    # if $Contype is set at all we know it's a 3D file sent from the 2D
    # but we can't be sure if it's vrml vs oogl, the setting 
    # is only guaranteed to be right the first time weboogl.perl 
    # is invoked from the 2D browser. 
    # so, check for the VRML header to distinguish from OOGL
    $type = "vrml" if (defined($Contype) && substr($content,0,80) =~ /VRML/);

    if ($type =~ /vrml/) { 
       open(CONVERT, "| $SHELL -c 'vrml2oogl $handle 2> /dev/null'"); 
#       print STDERR "| vrml2oogl $handle "; 
       print CONVERT $content if defined($content);
       print("(emodule-transmit weboogl.perl \"(RegisterURL $url)\n\")\n");
#       print STDERR "(emodule-transmit weboogl.perl \"(RegisterURL $url)\n\")\n";
    } elsif ($type =~ /oogl/) {
       open(CONVERT, "| woogl2oogl $handle ");
       print CONVERT $content if defined($content);
       print "(emodule-transmit weboogl.perl \"(RegisterURL $url)\n\")\n";
#       print STDERR "(emodule-transmit weboogl.perl \"(RegisterURL $url)\n\")\n";
    } else {
        # use -remote for netscape and signals for xmosaic.
        # sigh. counting the days til CCI is implemented everywhere,
        # wait until more people are using mosaic 2.5 to bother changing.
        #
        # get name of browser from pid through ps
	# bit of a hack, but should work under both SysV and BSD. 
	$psreturn = `ps -ea | grep $browser_pid` if ($browser_pid);
        if ($psreturn =~ /aic/) {
	    # Mosaic already running; tell it to open $url via USR1 signal.
	    open(MOSAIC_REQUEST, ">/tmp/Mosaic.$browser_pid");
	    truncate(MOSAIC_REQUEST, 0);
	    print MOSAIC_REQUEST "goto\n$url\n";
	    close(MOSAIC_REQUEST);
	    system("kill -USR1 $browser_pid");
	} else {
            system("netscape -remote \'openUrl($url)\'");
        }
    }
    close(CONVERT);
}


