Require text.tcl
Require label.tcl
Require button.tcl
Require ctrl-k.tcl
Require option.tcl

_option(Add) Button.relief		groove 
_option(Add) Button.borderWidth		3 

_option(Add) frame.box.relief 		groove 
_option(Add) frame.box.borderWidth 	2 
_option(Add) label(pady) 		0 

set _label(pady)   [option get . label(pady) *]

frame .frame; pack .frame -padx 10 -pady 7 -expand true -fill both

_button(Box) .frame bbox left {
  {Action view "_View..." _image(View) -width 10}
  {Action snapshot "_Snapshot..." _image(Snapshot) -width 10}
}

frame .frame.box
pack .frame.box -pady 5 -padx [option get .frame.box borderWidth *]
frame .frame.frame; pack .frame.frame -in .frame.box -padx 5 -pady 5

_label(Menu) .frame.frame \
  size "Size: " size {{Get Current Size} {Set Size...} \
                      {Mpeg Size} {Video Size}} {} 10
_label(Menu) .frame.frame \
  scale "Scale: " scale {1:1 2:1 3:2 4:3} {1:1} 10
_label(Menu) .frame.frame \
  colors "Colors: " colors {32 64 128 256 Millions} 256 10

_menu(Menu) .frame.frame colors.menu {
   Line
  {Check Dither _image(dither) {} checked}
}

.frame.frame.size.menu entryconfig "Get *"   -command _image(GetSize)
.frame.frame.size.menu entryconfig "Set *"   -command _image(SetSize)
.frame.frame.size.menu entryconfig "Mpeg *"  -command _image(MpegSize)
.frame.frame.size.menu entryconfig "Video *" -command _image(VideoSize)
.frame.frame.size.menu insert "Mpeg *" separator

_button(Button) .frame top Action quit _Quit exit

wm title . $_program(id)
