Require option.tcl

toplevel .message
wm withdraw .message

_option(Add) message.text.font $_button(font) 
label .message.text -textvariable _message(text)

pack .message.text -padx 10 -pady 10

proc _message(Set) {message {time 2}} {
  global _message
  set _message(text) $message
  set time [expr int($time*1000)]
  set _message(timer) 0
  after $time {set _message(timer) 1}
  if [info exists _message(idle)] {after cancel $_message(idle)}
  update idletasks
  if ![winfo ismapped .message] {
    wm deiconify .message
    tkwait visibility .message
    update
  }
  set _message(idle) [after idle {_message(Clear)}]
}

proc _message(Clear) {{now 0}} {
  global _message
  if [info exists _message(idle)] {after cancel $_message(idle)}
  if {$_message(timer) == 0 && !$now} {tkwait variable _message(timer)}
  set _message(timer) 0
  wm withdraw .message
  update idletasks
}
