Require name.tcl
Require fname.tcl
Require commands.tcl

proc _driver(BeginSnapshot) {} {}
proc _driver(Snapshot) {image file type w h colors dither} {}
proc _driver(Convert)  {image file type w h colors dither} {}
proc _driver(EndSnapshot) {} {}

proc _driver(SizeWindow) {w h {x ""} {y ""}} {}
proc _driver(GetWindowSize) {w h} {}
set  _driver(tmpfile) "/tmp/sm-[pid].tmp"

set _image(shader)  {}
set _image(quality) 90
set _image(scale)   1


proc _image(Snapshot) {} {
  global env
  _fname(NewFile) \
      "Save snapshot as:\n(file extension specifies image format)" \
      "" {_image(_Snapshot) %N} "" $env(PWD)
}

proc _image(_Snapshot) {name} {
  global _image _driver size scale colors message
  _fname(Close)
  set type [string range [string tolower [file extension $name]] 1 end]
  if {$type == ""} {set type "gif"}
  if {$colors == "millions"} {set colors ""}
  regexp {([0-9]+) x ([0-9]+)} $size wh w h
  set W $w; set H $h
  _message(Set) "Creating [string toupper $type] file ($w x $h)"
  set _image(scale) [string index $scale 0]
  set _image(colors) $colors; set dither $_image(dither)
  set _image(tmpfile) $_driver(tmpfile)
  _image(_ScaleSize) W H
  _driver(BeginSnapshot)
  _driver(Snapshot) $_image(tmpfile) $name $type $W $H $colors $dither
  _driver(EndSnapshot)
  _driver(Convert)  $_image(tmpfile) $name $type $w $h $colors $dither {}
  if {$_image(tmpfile) != $name} {exec /bin/rm -f $_image(tmpfile)}
  _message(Clear)
}


proc _image(SetSize) {} {
  _driver(GetWindowSize) w h
  _name(Request) "Set window size to:" "$w x $h" \
      {_image(_SetSize) $_name(name)} {} "a window size"
}

proc _image(_SetSize) {size} {
  global _image
  if [regexp \
       {^ *(([0-9]+) *x *([0-9]+))? *(([\+-][0-9]+) *([\+-][0-9]+))?$} \
	  $size junk wh w h xy x y ] {
    if {$wh == ""} {_driver(GetWindowSize) w h}
    _image(WindowSize) $w $h $x $y
  } else {
    Error "Bad window size: '$size'\nIt should be 'WxH', '+X+Y' or 'WxH+X+Y'"
  }
}

proc _image(MpegSize) {} \
    {global _image; _image(_SetSize) $_image(.mpeg.size)}
proc _image(VideoSize) {} \
    {global _image; _image(_SetSize) $_image(.video.size)}

proc _image(View) {} {
  global env
  _fname(OldFile) "View image from file:" {} {_image(_View) {%N}} {} $env(PWD)
}
proc _image(_View) {{name ""}} {eval exec [_viewer(Image) $name] >@stderr &}


proc _image(WindowSize) {w h {x ""} {y ""} args} {
  global size
  eval [list _driver(SizeWindow) $w $h $x $y] $args
  set size "$w x $h"
}

proc _image(GetSize) {} {
  global size
  _driver(GetWindowSize) w h
  set size "$w x $h"
}

