Require menu.tcl
Require text.tcl
Require button.tcl
Require ctrl-k.tcl
Require option.tcl

_option(Add) Button.relief	groove 
_option(Add) Button.borderWidth	3 

_menu(Bar) . mbar {

  _File file {
    {Action _New 	  _file(New)}
    {Action _Open...      _file(Open)}
    {Action _Save         _file(Save)}
    {Action "Save _As..." _file(SaveAs)}
    {Action _Revert       _file(Revert)}
     Line
    {Menu
      "_Clean Up" cleanup {
        {Action _Frames            _remove(Frames)}
        {Action _Snapshots         _remove(Snapshots)}
        {Action "_Temporary Files" _remove(TemporaryFiles)}
        {Action "_Output Files"    _remove(OutputFiles)}
        {Action "_All Files"       _remove(AllFiles)}
         Line
        {Action "All _Movies"      _remove(Everything)}
      }
    }
     Line
    {Action _Quit 	   exit}
  }

  _Edit edit {
    {Action Cut    _edit(Cut)   Ctrl-W}
    {Action _Copy  _edit(Copy)  ESC-W}
    {Action _Paste _edit(Paste) Ctrl-Y}
     Line
    {Action Clear  _edit(Clear) BS}
  }

  _Movie movie {
    {Action _New...       _movie(New)}
    {Action _Duplicate... _movie(Duplicate)}
    {Action _Rename...    _movie(Rename)}
     Line
    {Action Delete        _movie(Delete)}
     Line
    {Action _Import...    _movie(Import)}
    {Action _Export...    _movie(Export)}
  }

  _Scene scene {
    {Check scene-0 _scenes(scene-0) _scene(Set) checked}
     Line
    {Check _All    _scene(all)      _scene(All) checked}
    {Action _None                   _scene(None)}
    {Action "_Remake List"          _scene(RemakeList)}
  }

  _Image image {
    {Menu
      _Size size {
	{Radio _Mpeg           _image(size) m  _image(MpegSize) checked}
	{Radio _Video          _image(size) v  _image(VideoSize)}
	{Radio "_Other..."     _image(size) wh _image(SetSize)}
	 Line
	{Action "_Current Size" _image(GetSize)}
      }
    }
    {Menu
      Sc_ale scale {
	{Radio "_1:1" _image(scale) 1 _image(SetScale) checked}
	{Radio "_2:1" _image(scale) 2 _image(SetScale)}
	{Radio "_3:2" _image(scale) 3 _image(SetScale)}
	{Radio "_4:3" _image(scale) 4 _image(SetScale)}
      }
    }
    {Menu
      _Type type {
	{Radio _TIFF _image(type) tiff}
        {Radio _PNM  _image(type) pnm}
	{Radio _GIF  _image(type) gif {} checked}
        {Radio _JPEG _image(type) jpg}
	{Radio  PS   _image(type) ps}
      }
    }
    {Menu
      _Colors colors {
	{Radio 32       _image(colors)}
	{Radio 64       _image(colors)}
	{Radio 128      _image(colors)}
	{Radio 256      _image(colors) 256 {} checked}
	{Radio Millions _image(colors)}
         Line
        {Check _Dither  _image(dither) {} checked}
      }
    }
     Line
    {Action "S_napshot..." _image(Snapshot)}
    {Action "_Recale Image..." _image(Rescale)}
  }

  _Options options {
    {Action "_Frame parameters..." _fparam(Open)}
    {Action "_Image parameters..." _iparam(Open)}
    {Action "_Mpeg parameters..."  _mparam(Open)}
    {Action "_Animated GIF parameters..." _gparam(Open)}
    {Action "_Video parameters..." {} {} -state disabled}
     Line
    {Menu
      "_Stop At" stop {
	{Radio "Every _Frame"    _options(stopAt) frame}
	{Radio "Every _Scene"    _options(stopAt) scene}
	{Radio _End              _options(stopAt) end    {} checked}
      }
    }
  }

  _Tools tools {
    {Action "Messages"          _tool(Messages)}
     Line
    {Action "_Mpeg Viewer..."   _tool(MpegViewer)}
    {Action "_Image Viewer..."  _tool(ImageViewer)}
    {Action "_Animated GIF Viewer..." _tool(AnimGIFViewer)}
    {Action "_Web Browser..."   _tool(WebBrowser)}
    {Action "_Video Control..." _tool(VideoControl) {} -state disabled}
     Line
    {Action _StageHand          _tool(StageHand)}
  }

  _Action action {
    {Check "Save _Frames"    _action(frames)}
    {Check "Save _Snapshots" _action(snapshots)}
    {Check "Make _MPEG"      _action(mpeg)}
    {Check "Make _Animated GIF" _action(animGIF)}
    {Check "Make _Video"     _action(video)}
  }

  >> _Help help {
    {Action _About          _help(About)}
    {Action "_Browser..."   _help(Browser)}
  }
}

_button(Box) . bbox top {
  {Action execute E_xecute        _execute(Script)}
} right

_button(Box) . bbox bottom {
  {Action quit _Quit exit}
}
_menu(Scrollable) .bbox names "Movies" 12 3 1
_text(Scrollable) . script 45 10 1 top 1
wm minsize . 400 175

_ctrlK(Bind) .script

set _pack(Array:_options) {framePauses stopAt}
proc _vcheck(_options) {list} {
  if [_file(EarlierV) 2.5] {
    set list [list [lindex $list 0] [lindex $list 3] \
                   [lindex $list 1] [lindex $list 2]]
  }
  return [_driver(vCheck) options $list]
}
