Require fname.tcl
Require execute.tcl
Require commands.tcl
Require confirm.tcl

proc _tool(Messages) {} {StageDoor "Message Open"}

proc _tool(MpegViewer) {} {
  global _file env
  _execute(GetFilenames)
  _execute(CheckDir) $_file(root)
  _fname(OldFile) "Play MPEG from file:" $_file(mpeg) \
      {_tool(MPEG) {%N}} .mpg $env(PWD)
}
proc _tool(MPEG) {{name ""}} {eval exec [_viewer(MPEG) $name] >@stderr &}

proc _tool(ImageViewer) {} {
  global _file env
  _execute(GetFilenames)
  _execute(CheckDir) $_file(root)
  _fname(OldFile) "View image from file:" $_file(base) \
      {_tool(Image) {%N}} {} $env(PWD)
}
proc _tool(Image) {{name ""}} {eval exec [_viewer(Image) $name] >@stderr &}

proc _tool(AnimGIFViewer) {} {
  global _file env
  _execute(GetFilenames)
  _execute(CheckDir) $_file(root)
  _fname(OldFile) "View animated GIF from file:" $_file(base) \
      {_tool(AnimGIF) {%N}} .gif $env(PWD)
}
proc _tool(AnimGIF) {{name ""}} {
  set viewer [_viewer(AnimGIF) $name]
  eval exec $viewer >@stderr &
  if {[regexp {netscape} [string tolower [lindex $viewer 0]]]} {
    _fname(Close)
    ConfirmOK "Launched \"[lindex $viewer 0]\""
  }
}

proc _tool(WebBrowser) {{name ""}} {
  set viewer [_viewer(Web) $name]
  eval exec $viewer >@stderr &
  _fname(Close)
  ConfirmOK "Launched \"[lindex $viewer 0]\""
}

proc _tool(RunGCL) {} {
  global _file env
  _execute(GetFilenames)
  _execute(CheckDir) $_file(root)
  _fname(OldFile) "Run GCL from file:" $_file(gcl) \
      {_tool(GCL) {%N}} .gcl $env(PWD)
}

proc _tool(GCL) {name} {_command(TellGV) "(load \"[_Quote $name]\")"}

proc _tool(VideoControl) {} {}

proc _tool(StageHand) {} {StageDoor "Start StageHand"}
