Require pack.tcl

set _scene(list) {scene-0}

proc _scene(All) {} {
  global _scene _scenes
  foreach name $_scene(list) {set _scenes($name) 1}
}

proc _scene(None) {} {
  global _scene _scenes
  foreach name $_scene(list) {set _scenes($name) 0}
  set _scene(all) 0
}

proc _scene(Set) {} {global _scene; set _scene(all) 0}

proc _scene(RemakeList) {} {
  set scenes {{scene-0 1}}
  set i 0
  foreach line [split [.script get 0.0 end] \n] {
    if {[lindex $line 0] == "Scene"} {
      incr i; set name [lindex $line 1]
      if {$name == ""} {set name "scene-$i"}
      lappend scenes [list $name 1]
    }
  }
  _unpack(_Scene) $scenes
}

lappend _pack(procs) Scene

proc _pack(_Scene) {} {
  global _scene _scenes
  set data {}
  foreach name $_scene(list) {lappend data [list $name $_scenes($name)]}
  return $data
}

proc _unpack(_Scene) {list} {
  global _scene _scenes
  catch {unset _scenes}
  set _scene(list) {}
  .mbar.scene.menu delete 1 [expr [.mbar.scene.menu index end] - 4]
  set i 1
  foreach pair $list {
    set name [lindex $pair 0]
    lappend _scene(list) $name
    .mbar.scene.menu insert $i check -label $name \
	-var _scenes($name) -command _scene(Set)
    if {$_scene(all) || [lindex $pair 1]} {set _scenes($name) 1}
    incr i
  }
}

proc _vcheck(_Scene) {list} {return [_driver(vCheck) Scene $list]}