proc _driver(ControlFileNames) {} {}

proc _remove(Frames) {} {
  global _file
  _execute(GetFilenames)
  if [Confirm "Really delete frames directory\
        '$_file(frameroot)' and its contents?"] return
  exec /bin/rm -r $_file(frameroot)
}

proc _remove(Snapshots) {} {
  global _file
  _execute(GetFilenames)
  if [Confirm "Really delete snapshot directory\
        '$_file(imageroot)' and its contents?"] return
  exec /bin/rm -r $_file(imageroot)
}

proc _remove(TemporaryFiles) {} {
  global _file
  _execute(GetFilenames)
  set list "$_file(param) $_file(video) $_file(base).record $_file(base).log "
  append list [_driver(TemporaryFileNames)]
  _remove(List) $list
}

proc _remove(OutputFiles) {} {
  global _file
  _execute(GetFilenames)
  set list "$_file(mpeg) $_file(animGIF) $_file(video)"
  append list [_driver(OutputFileNames)]
  _remove(List) $list
}

proc _remove(AllFiles) {} {
  global _file
  _execute(GetFilenames)
  _remove(List) [glob -nocomplain $_file(base)*]
}

proc _remove(Everything) {} {
  global _file
  _execute(GetFilenames)
  if [Confirm "Really delete all files\
         in the '$_file(root)' directory?"] return
  exec /bin/rm -r $_file(root)
}

proc _remove(List) {list} {
  set i 0
  foreach name $list {
    if ![file exists $name] break
    if [Confirm "Really delete '$name'?"] break
    exec /bin/rm -r $name
    incr i
  }
  if {$i == 0} {ConfirmOK "No such files currently exist."}
}