set _pack(arrays) {}
set _pack(vars) {}
set _pack(procs) {}
set _pack(text) .script

proc _driver(vCheck) {type list} {return $list}

proc _pack(All) {} {
  return [list [_pack(Text)] [_pack(Data)]]
}

proc _unpack(All) {list {ignore 0}} {
  _unpack(Text) [lindex $list 0]
  if {!$ignore && [llength $list] > 1} {
    _unpack(Data) [lindex $list 1]
  }
}

proc _vcheck(All) {list} {
  return [list [_vcheck(Text) [lindex $list 0]] \
               [_vcheck(Data) [lindex $list 1]]]
}

proc _pack(Text) {} {
  global _pack
  return [_pack(Quote) [$_pack(text) get 0.0 end-1c]]
}

proc _unpack(Text) {string} {
  global _pack
  $_pack(text) delete 0.0 end
  $_pack(text) insert end [_unpack(Quote) $string]
  $_pack(text) mark set insert 0.0
}

proc _vcheck(Text) {text} {return [_driver(vCheck) Text $text]}


proc _pack(Quote) {string} {
  regsub -all {[\{\}]} $string {\\&} string
  return $string
}

proc _unpack(Quote) {string} {
  regsub -all {\\([\{\}])} $string {\1} string
  return $string
}


proc _pack(Data) {} {
  return [list [_pack(Arrays)] [_pack(Vars)] [_pack(Procs)]]
}

proc _unpack(Data) {list} {
  _unpack(Arrays) [lindex $list 0]
  _unpack(Vars)   [lindex $list 1]
  _unpack(Procs)  [lindex $list 2]
}

proc _vcheck(Data) {list} {
  return [list \
    [_vcheck(Arrays) [lindex $list 0]] \
    [_vcheck(Vars)   [lindex $list 1]] \
    [_vcheck(Procs)  [lindex $list 2]] \
  ]
}


proc _pack(Arrays) {} {
  global _pack
  set list {}
  foreach array [lsort [array names _pack Array:*]] {
    set array [string range $array 6 end]
    lappend list [_pack(Array) $array $_pack(Array:$array)]
  }
  return $list
}
proc _pack(Array) {array indices} {
  set list {}
  upvar \#0 $array a
  if {[llength $indices] == 0} {set indices [lsort [array names a]]}
  foreach index $indices \
      {if {[string index $index 0] != "."} {lappend list $a($index)}}
  return $list
}

proc _unpack(Arrays) {list} {
  global _pack
  set i 0
  foreach array [lsort [array names _pack Array:*]] {
    set array [string range $array 6 end]
    _unpack(Array) $array $_pack(Array:$array) [lindex $list $i]
    incr i
  }
}
proc _unpack(Array) {array indices list} {
  upvar \#0 $array a
  set i 0
  if {[llength $indices] == 0} {set indices [lsort [array names a]]}
  foreach index $indices {
    if {[string index $index 0] != "."} \
	{set a($index) [lindex $list $i]; incr i}
  }
}

proc _vcheck(Arrays) {list} {
  global _pack
  set i 0; set newlist {}
  if [_file(EarlierV) 2.5] {
    set list [list [lindex $list 3] [lindex $list 1] \
                   [lindex $list 2] [lindex $list 0]]
  }
  foreach array [lsort [array names _pack Array:*]] {
    lappend newlist [_vcheck([string range $array 6 end]) [lindex $list $i]]
    incr i
  }
  return $newlist
}


proc _pack(Vars) {} {
  global _pack
  set list {}
  foreach var $_pack(vars) {lappend list [_pack(Var) $var]}
  return $list
}
proc _pack(Var) {v} {return [uplevel \#0 "set $v"]}

proc _unpack(Vars) {list} {
  global _pack
  set i 0
  foreach var $_pack(vars) {_unpack(Var) $var [lindex $list $i]; incr i}
}
proc _unpack(Var) {var value} {uplevel \#0 [list set $var $value]}

proc _vcheck(Vars) {list} {return [_driver(vCheck) Vars $list]}


proc _pack(Procs) {} {
  global _pack
  set list {}
  foreach proc $_pack(procs) {lappend list [_pack(_$proc)]}
  return $list
}

proc _unpack(Procs) {list} {
  global _pack
  set i 0
  foreach proc $_pack(procs) {
    _unpack(_$proc) [lindex $list $i]
    incr i
  }
}

proc _vcheck(Procs) {list} {
  global _pack
  set i 0; set newlist {}
  foreach proc $_pack(procs) {
    lappend newlist [_vcheck(_$proc) [lindex $list $i]]
    incr i
  }
  return $newlist
}


