Require label.tcl
Require button.tcl
Require option.tcl

_option(Add) mparam.line.relief groove 
_option(Add) mparam.line.borderWidth 2 
_option(Add) mparam*algb.padY 2 
_option(Add) mparam*algp.padY 2 
_option(Add) mparam*pixel.padY 2 

set _mpeg(pattern) IPPPPP
set _mpeg(pixel)   Full
set _mpeg(range)   10
set _mpeg(IQ)      6
set _mpeg(PQ)      10
set _mpeg(BQ)      8
set _mpeg(algP)    Logarithmic
set _mpeg(algB)    Cross2
set _mpeg(keep)    1
set _mpeg(run)     1

toplevel .mparam
wm title .mparam "$_program(id): MPEG Parameters"
wm withdraw .mparam
wm group .mparam .
wm resizable .mparam 0 0

frame .mparam.frame; pack .mparam.frame -padx 10 -pady 7
_label(Entry) .mparam.frame pattern "Pattern:" _mparam(pattern) 21

frame .mparam.row; pack .mparam.row -in .mparam.frame -fill x
_label(Menu)  .mparam.row pixel "Pixel:" _mparam(pixel) {Full Half} {} {}\
    -side left
_label(Entry) .mparam.row range "Range:" _mparam(range) 5 {-side right}

frame .mparam.line; pack .mparam.line -in .mparam.frame -padx 2 -pady 5 -fill x
frame .mparam.box -relief flat
pack .mparam.box -in .mparam.line -pady 3 -padx 5 -fill x
_label(Entry) .mparam.box iq "IQ scale:" _mparam(IQ) 5
_label(Entry) .mparam.box pq "PQ scale:" _mparam(PQ) 5
_label(Entry) .mparam.box bq "BQ scale:" _mparam(BQ) 5
_menu(Popup) .mparam.box.pq(frame) algp _mparam(algP) \
    {Logarithmic Subsample TwoLevel Exhaustive} {} 11
_menu(Popup) .mparam.box.bq(frame) algb _mparam(algB) \
    {Simple Cross2 Exhaustive} Cross2 11
pack configure .mparam.box.iq(title) -side left
pack configure .mparam.box.iq -side left -after .mparam.box.iq(title)
pack configure .mparam.box.pq(title) -side left
pack configure .mparam.box.pq -side left -after .mparam.box.pq(title)
pack configure .mparam.box.bq(title) -side left
pack configure .mparam.box.bq -side left -after .mparam.box.bq(title)
.mparam.box.iq(title) configure -width 9
.mparam.box.pq(title) configure -width 9
.mparam.box.bq(title) configure -width 9

pack .mparam.box.pq(frame).algp -side right
pack .mparam.box.bq(frame).algb -side right

_button(Button) .mparam.frame {right -pady 0} Action ok _OK _mparam(OK)
_button(Button) .mparam.frame {left -pady 0} \
    Action cancel _Cancel _mparam(Cancel)
_button(Button) .mparam.frame {left -fill none -expand true} \
    Action default _Restore _mparam(Defaults)
_button(Button) .mparam.frame {left -fill none -expand true} \
    Action setdef _Save _mparam(SetDefaults)

bind .mparam <Escape>   [bind .mparam <Alt-c>]
bind .mparam <KP_Enter> [bind .mparam <Alt-o>]

proc _mparam(Close) {} {wm withdraw .mparam; update idletasks}
proc _mparam(Cancel) {} _mparam(Close)

proc _mparam(OK) {} {
  global _mpeg _mparam
  _mparam(Close)
  foreach name [array names _mpeg] {set _mpeg($name) $_mparam($name)}
}

proc _mparam(Open) {} {
  global _mpeg _mparam
  foreach name [array names _mpeg] {set _mparam($name) $_mpeg($name)}
  if [winfo ismapped .mparam] {wm withdraw .mparam}
  wm deiconify .mparam
  focus .mparam.frame.ok
}

proc _mparam(Defaults) {} {
  global _mparam _mpeg
  foreach pair $_mparam(default) \
    {set _mparam([lindex $pair 0]) [lindex $pair 1]}
}

proc _mparam(SetDefaults) {} {
  global _mparam _mpeg
  set _mparam(default) {}
  foreach name [lsort [array names _mpeg]] \
    {lappend _mparam(default) "$name $_mparam($name)"}
}

foreach name [lsort [array names _mpeg]] \
  {lappend _mparam(default) "$name $_mpeg($name)"}


set _pack(Array:_mpeg) {BQ IQ PQ algB algP keep pattern pixel range run}
proc _vcheck(_mpeg) {list} {return [_driver(vCheck) mpeg $list]}