Require name.tcl
Require fname.tcl
Require confirm.tcl
Require pack.tcl

set _movie(name) "Untiled"

proc _movie(New) {} {
  _name(Request) "Name for new movie:" "" {_movie(_New) $_name(name)}
}

proc _movie(_New) {name} {
  global _movie
  _data(Save) $_movie(name)
  _data(RemoveEmpty)

  set name [_data(UniqueName) $name]
  _data(Insert) $name 
  _data(Copy) {} $name
  _data(Select) $name
}


proc _movie(Duplicate) {} {
  global _movie
  set name [_data(UniqueName) $_movie(name)]
  _name(Request) "Name for duplicate movie:" $_movie(name)\
      "_movie(_Duplicate) $_movie(name) \$_name(name)"
}

proc _movie(_Duplicate) {old new} {
  global _movie
  _data(Save) $_movie(name)
  set new [_data(UniqueName) $new]
  _data(Copy) $old $new
  _data(Insert) $new
  _data(Select) $new
}

proc _movie(Rename) {} {
  global _movie
  _name(Request) "Rename movie '$_movie(name)' as:" $_movie(name)\
      {_movie(_Rename) $_movie(name) $_name(name)}
}

proc _movie(_Rename) {old new} {
  global _movie _file
  _data(Save) $_movie(name)
  _execute(GetFilenames)
  set oldbase $_file(base); set len [string length $oldbase]
  set new [_data(UniqueName) $new]
  _data(Copy) $old $new
  _data(Delete) $old
  _data(Insert) $new
  _data(Select) $new
  _execute(GetFilenames)
  foreach file [glob -nocomplain $oldbase*] \
      {exec /bin/mv $file $_file(base)[string range $file $len end]}
}

proc _movie(Delete) {} {
  global _movie
  if [Confirm "Really delete movie '$_movie(name)'?"] return
  set id [_data(FindID) $_movie(name)]
  _data(Delete) $_movie(name)
  if {[_data(Count)] == 0} {_data(MakeUntitled)}
  _data(Select) [_data(FindName) $id]
}

proc _movie(Import) {} {
  global _file
  _fname(OldFile) "Import movies from file:" "" \
      {_file(_Load) {%N}} .sm $_file(pwd)
}

proc _movie(Export) {} {
  global _movie _file
  _fname(NewFile) "Export movie '$_movie(name)' to file:" \
      "$_movie(name).sm" {_file(_Save) {%N} new selected} .sm $_file(pwd)
}


proc _data(Save) {name} {
  global _data _position _file _pack
  set data [_pack(All)]
  if {![info exists _data($name)] || $data != $_data($name)} {
    set _file(changed) 1
  }
  set _data($name) $data
  set _position($name) [list \
    [$_pack(text) index insert] \
    [lindex [$_pack(text) xview] 0] \
    [lindex [$_pack(text) yview] 0] \
  ]
}
proc _data(Restore) {name} {
  global _data _position _pack
  _unpack(All) $_data($name)
  if [info exists _position($name)] {
    $_pack(text) mark set insert [lindex $_position($name) 0]
    $_pack(text) xview moveto [lindex $_position($name) 1]
    $_pack(text) yview moveto [lindex $_position($name) 2]
    $_pack(text) see insert
  }
}

proc _data(Select) {name} {
  global _movie
  set i [_data(FindID) $name]
  .bbox.names selection clear 0 end
  .bbox.names selection set $i
  .bbox.names see [.bbox.names curselection]
  set _movie(name) [.bbox.names get $i]
  set _movie(id) $i
  _data(Restore) $_movie(name)
  _data(ResetWindows)
}

proc _data(FindID) {name} {
  set m [_data(Count)]
  for {set i 0} {$i < $m} {incr i} {
    if {$name == [_data(FindName) $i]} {return $i}
  }
  return 0
}

proc _data(FindName) {id} {.bbox.names get $id}

proc _data(UniqueName) {name} {
  set n 0; set movie $name
  set m [_data(Count)]
  for {set i 0} {$i < $m} {incr i} {
    set check [_data(FindName) $i]
    if {$movie < $check} break
    if {$movie == $check} {incr n; set movie "$name-$n"}
  }
  return $movie
}

proc _data(Count) {} {.bbox.names size}

proc _data(Insert) {name} {
  set m [_data(Count)]
  for {set i 0} {$i < $m} {incr i} {if {$name < [_data(FindName) $i]} break}
  .bbox.names insert $i $name
}

proc _data(Delete) {name} {
  global _data _position _file
  .bbox.names delete [_data(FindID) $name]
  catch {unset _data($name); unset _position($name); set _file(changed) 1}
}

proc _data(Clear) {} {
  global _data _position
  unset _data
  unset _position
  .bbox.names delete 0 end
  _data(MakeUntitled)
  _data(Select) Untitled
}

proc _data(Copy) {old new} {
  global _movie _data _position _file
  if [info exists _data($old)] {
    set _data($new) $_data($old)
    set _position($new) $_position($old)
  } else {
    set _data($new) $_movie(default)
    set _position($new) {0.0 0 0}
  }
  set _file(changed) 1
}

proc _data(RemoveEmpty) {} {
  global _movie _data
  if [info exists _data(Untitled)] {
    if {$_data(Untitled) == $_movie(default)} {_data(Delete) Untitled}
  }
}

proc _data(MakeUntitled) {} {
  global _movie _data
  set name [_data(UniqueName) Untitled]
  set _data($name) $_movie(default)
  set _position($name) {0.0 0 0}
  _data(Insert) $name
  _data(Select) $name
}


set _movie(reset.wins)    {.name}
set _movie(reset.actions) {frames snapshots mpeg video animGIF}
set _movie(reset.procs)   {}

proc _data(ResetWindows) {} {
  global _movie
  foreach win  $_movie(reset.wins)    {wm withdraw $win}
  foreach var  $_movie(reset.actions) {set _action($var) 0}
  foreach proc $_movie(reset.procs)   {eval $proc}
}

bind _data(keymap) <Any-KeyPress> {_data(Hit) %W}
bind _data(keymap) <Any-1> {_data(Hit) %W}
bind _data(keymap) <Any-2> {_data(Hit) %W}
bind _data(keymap) <Any-3> {_data(Hit) %W}
bind _data(keymap) <Any-ButtonRelease-1> {_data(Hit) %W}
bind _data(keymap) <Any-ButtonRelease-2> {_data(Hit) %W}
bind _data(keymap) <Any-ButtonRelease-3> {_data(Hit) %W}
bind _data(keymap) <Any-B1-Motion> {_data(Hit) %W}

proc _data(Hit) {w} {
  global _movie
  set i [$w curselection]
  if {$i != $_movie(id)} {
    _data(Save) $_movie(name)
    _data(Select) [_data(FindName) $i]
  }
}

bindtags .bbox.names {.bbox.names Listbox _data(keymap) . all}
