Require label.tcl
Require button.tcl

set _iparam(quality) 90
set _image(quality)  90

toplevel .iparam
wm title .iparam "$_program(id): Image Parameters"
wm withdraw .iparam
wm group .iparam .
wm resizable .iparam 0 0

frame .iparam.box; pack .iparam.box -padx 10 -pady 7
_label(Entry) .iparam.box speed      "JPEG Quality:" _iparam(quality)
frame .iparam.box.space -relief flat; pack .iparam.box.space -pady 2
_button(Button) .iparam.box {right -pady 0} Action ok _OK _iparam(OK)
_button(Button) .iparam.box {left -pady 0} \
    Action cancel _Cancel _iparam(Cancel)

bind .iparam <Escape>   [bind .iparam <Alt-c>]
bind .iparam <KP_Enter> [bind .iparam <Alt-o>]

proc _iparam(Close) {} {wm withdraw .iparam; update idletasks}
proc _iparam(Cancel) {} _iparam(Close)

proc _iparam(OK) {} {
  global _image _iparam
  _iparam(Close)
  foreach name [array names _iparam] {set _image($name) $_iparam($name)}
}

proc _iparam(Open) {} {
  global _image _iparam
  foreach name [array names _iparam] {set _iparam($name) $_image($name)}
  if [winfo ismapped .iparam] {wm withdraw .iparam}
  wm deiconify .iparam
  focus .iparam.box.ok
}
