Require name.tcl
Require fname.tcl
Require execute.tcl
Require scale.tcl

proc _driver(BeginSnapshot) {} {}
proc _driver(Snapshot) {image file type w h colors dither} {}
proc _driver(Convert)  {image file type w h colors dither} {}
proc _driver(EndSnapshot) {} {}

proc _driver(SizeWindow) {w h {x ""} {y ""}} {}
proc _driver(GetWindowSize) {w h} {}
set  _driver(tmpfile) "/tmp/sm-[pid].tmp"


set _image(wh) {}
set _image(shader) {}


proc _image(MpegSize) {} \
    {global _image; _image(_SetSize) $_image(.mpeg.size)}
proc _image(VideoSize) {} \
    {global _image; _image(_SetSize) $_image(.video.size)}

proc _image(SetSize) {} {
  global _image
  _name(Request) "Set window size to:" $_image(wh) \
      {_image(_SetSize) $_name(name)} {} "a window size"
}

proc _image(GetSize) {} {
  global _image
  _driver(GetWindowSize) w h
  _image(_SaveSize) $w $h
}

proc _image(SetScale) {} {global _image; _image(_SetSize) $_image(wh)}

proc _image(Snapshot) {} {
  global _file  env
  _execute(GetFilenames)
  _execute(CheckDir) $_file(root)
  _fname(NewFile) \
      "Save snapshot as:\n(file extension specifies image format)" \
      $_file(root) {_image(_Snapshot) %N} "" $env(PWD)
}

proc _image(Rescale) {} {
  global _file env
  _execute(GetFilenames)
  _execute(CheckDir) $_file(root)
  _fname(OldFile) \
      "Rescale image:" $_file(root) {_image(_Rescale) %N} "" $env(PWD)
}

proc _image(_Rescale) {name} {
  _name(Request) "Set image size to:" "" \
      "_image(__Rescale) $name \$_name(name)" {} "an image size"
}


proc _image(_Snapshot) {name} {
  global _image _driver
  _fname(Close)
  set title [wm title .]
  wm title . "Saving image to file '$name'..."; update idletasks
  set type [string range [string tolower [file extension $name]] 1 end]
  if {$type == ""} {set type "gif"}
  set colors $_image(colors); if {$colors == "millions"} {set colors ""}
  set dither $_image(dither)
  set w $_image(w); set W $_image(W); set h $_image(h); set H $_image(H)
  set _image(tmpfile) $_driver(tmpfile)
  _driver(BeginSnapshot)
  _driver(Snapshot) $_image(tmpfile) $name $type $W $H $colors $dither
  _driver(EndSnapshot)
  _driver(Convert)  $_image(tmpfile) $name $type $w $h $colors $dither
  if {$_image(tmpfile) != $name} {exec /bin/rm -f $_image(tmpfile)}
  wm title . $title
}


proc _image(__Rescale) {name size} {
  global _image _driver
  _name(Close)
  set wh [split $size x]; set w [lindex $wh 0]; set h [lindex $wh 1]
  set title [wm title .]
  wm title . "Converting '$name'..."; update idletasks
  set type [string range [string tolower [file extension $name]] 1 end]
  if {$type == ""} {set type "gif"}
  set colors $_image(colors); if {$colors == "millions"} {set colors ""}
  _driver(Convert)  $name $name $type $w $h $colors $_image(dither)
  wm title . $title
}



if {[info procs _image(tkerror)] == ""} {
  auto_load tkerror
  rename tkerror _image(tkerror)
  proc tkerror {message} {_file(SetTitle); _image(tkerror) $message}
}

proc _image(_SetSize) {size} {
  global _image
  if [regexp \
       {^ *(([0-9]+) *x *([0-9]+))? *(([\+-][0-9]+) *([\+-][0-9]+))?$} \
	  $size junk wh w h xy x y ] {
    if {$wh == ""} {_image(_GetSize) w h} else {_image(_SaveSize) $w $h}
    _image(WindowSize) $w $h $x $y
  } else {
    Error "Bad window size: '$size'\nIt should be 'WxH', '+X+Y' or 'WxH+X+Y'"
  }
}

proc _image(_SaveSize) {w h} {
  global _image
  set _image(wh) "$w\x$h"
  set _image(w) $w; set _image(h) $h
  set _image(W) $w; set _image(H) $h
  _image(_ScaleSize) _image(W) _image(H)
  if {$_image(wh) == $_image(.mpeg.size)}  {set _image(size) m} \
      elseif {$_image(wh) == $_image(.video.size)} {set _image(size) v} \
      else {set _image(size) wh}
}

proc _image(_GetSize) {W H} {
  global _image
  upvar $W w; upvar $H h
  regexp {([0-9]+)x([0-9]+)} $_image(wh) junk w h
  return [list $w $h]
}


proc _image(WindowSize) {w h {x ""} {y ""} args} {
  eval [list _driver(SizeWindow) $w $h $x $y] $args
}


set _image(.pack) {W H w h wh scale type colors quality dither}

proc _pack(_Image) {} {global _image; _pack(Array) _image $_image(.pack)}
proc _unpack(_Image) {list} {
  global _image
  _unpack(Array) _image $_image(.pack) $list
  _image(_SetSize) $_image(wh)
}
proc _vcheck(_Image) {list} {
  if [_file(EarlierV) 2.5] {
    set list [_driver(vCheck) Image2.4 $list]
    set list [list [lindex $list 1] [lindex $list 0] [lindex $list 10] \
                   [lindex $list 3] [lindex $list 11] [lindex $list 6] \
                   [lindex $list 9] [lindex $list 2] [lindex $list 4] \
                   1 [lindex $list 7]]
  }
  set list [_driver(vCheck) Image $list]
  if {[lindex $list 7] == 255} {set list [lreplace $list 7 7 256]}
  return $list
}

lappend _pack(procs) Image
