Require label.tcl
Require button.tcl

set _animGIF(loops) {forever}
set _animGIF(delay) {10}
set _animGIF(transparent) {}

toplevel .gparam
wm title .gparam "$_program(id): Animated GIF Parameters"
wm withdraw .gparam
wm group .gparam .
wm resizable .gparam 0 0

frame .gparam.box; pack .gparam.box -padx 10 -pady 7
_label(Entry) .gparam.box loops       "Loops:" _gparam(loops)
_label(Entry) .gparam.box delay       "Delay:" _gparam(delay)
_label(Entry) .gparam.box transparent "Transparent:" _gparam(transparent)
frame .gparam.box.space -relief flat; pack .gparam.box.space -pady 2
_button(Button) .gparam.box {right -pady 0} Action ok _OK _gparam(OK)
_button(Button) .gparam.box {left -pady 0} \
    Action cancel _Cancel _gparam(Cancel)

bind .gparam <Escape>   [bind .gparam <Alt-c>]
bind .gparam <KP_Enter> [bind .gparam <Alt-o>]

proc _gparam(Close) {} {wm withdraw .gparam; update idletasks}
proc _gparam(Cancel) {} _gparam(Close)

proc _gparam(OK) {} {
  global _animGIF _gparam
  _gparam(Close)
  foreach name [array names _animGIF] \
    {set _animGIF($name) [string trim $_gparam($name)]}
}

proc _gparam(Open) {} {
  global _animGIF _gparam
  foreach name [array names _animGIF] {set _gparam($name) $_animGIF($name)}
  if [winfo ismapped .gparam] {wm withdraw .gparam}
  wm deiconify .gparam
  focus .gparam.box.ok
}


set _pack(Array:_animGIF) {delay loops transparent}

proc _vcheck(_animGIF) {list} {
  if {$list == ""} {set list {10 forever {}}}
  if {[lindex $list 0] == "forever"} \
    {set list [list [lindex $list 1] [lindex $list 0] [lindex $list 2]]}
  return [_driver(vCheck) animGIF $list]
}