Require label.tcl
Require button.tcl

set _frame(speed) 1
set _frame(pause) 1
set _frame(resolution) 1

toplevel .fparam
wm title .fparam "$_program(id): Frame Parameters"
wm withdraw .fparam
wm group .fparam .
wm resizable .fparam 0 0

frame .fparam.box; pack .fparam.box -padx 10 -pady 7
_label(Entry) .fparam.box speed      "Speed:" _fparam(speed)
_label(Entry) .fparam.box pause      "Pause:" _fparam(pause)
_label(Entry) .fparam.box resolution "Resolution:" _fparam(resolution)
frame .fparam.box.space -relief flat; pack .fparam.box.space -pady 2
_button(Button) .fparam.box {right -pady 0} Action ok _OK _fparam(OK)
_button(Button) .fparam.box {left -pady 0} \
    Action cancel _Cancel _fparam(Cancel)

bind .fparam <Escape>   [bind .fparam <Alt-c>]
bind .fparam <KP_Enter> [bind .fparam <Alt-o>]

proc _fparam(Close) {} {wm withdraw .fparam; update idletasks}
proc _fparam(Cancel) {} _fparam(Close)

proc _fparam(OK) {} {
  global _frame _fparam
  _fparam(Close)
  foreach name [array names _frame] {set _frame($name) $_fparam($name)}
}

proc _fparam(Open) {} {
  global _frame _fparam
  foreach name [array names _frame] {set _fparam($name) $_frame($name)}
  if [winfo ismapped .fparam] {wm withdraw .fparam}
  wm deiconify .fparam
  focus .fparam.box.ok
}

set _pack(Array:_frame) {pause resolution speed}
proc _vcheck(_frame) {list} {return [_driver(vCheck) frame $list]}