Require fname.tcl
Require confirm.tcl
Require movie.tcl

set _file(changed) 0
set _file(default) Untitled.sm
set _file(pwd)     $env(PWD)
set _file(dir)     $_file(pwd)

#
# minimum version whose data can be read
#
set _file(majorV)  2
set _file(minorV)  0
set _file(ignore)  false

set _file(version)  $_program(version)
set _file(dversion)  0.0

set _driver(version) 0.0

proc _driver(FileV) {V} {}


proc _file(New) {} {
  global _file
  if [_file(Confirm) "Delete movies"] return
  _data(Clear)
  _file(Name) $_file(default)
}

proc _file(Open) {} {
  global _file
  if [_file(Confirm) "Load new movies"] return
  _fname(OldFile) "Load movies from file:" [file tail $_file(name)] \
      {_file(_Load) {%N} clear} .sm $_file(pwd)
}

proc _file(Save) {} {
  global _file
  if {$_file(name) == $_file(default)} {_file(SaveAs)} \
      else {_file(_Save) $_file(name) old}
}

proc _file(SaveAs) {} {
  global _file
  _fname(NewFile) "Save movies as:" [file tail $_file(name)] \
      {_file(_Save) {%N} new} .sm $_file(pwd)
}

proc _file(Revert) {} {
  global _file
  if [_file(Confirm) "Revert to old version of '$_file(name)'"] return
  _file(_Load) $_file(name) clear
}

proc _file(_Save) {name new {which all}} {
  global _movie _program _require _file _fname _driver env
  _data(Save) $_movie(name)
  _fname(Close)
  if {$which == "all"} {set name [_file(Name) $name]}
#  if {$new == "new"} {set _file(dir) [file dirname $name]}
  set file [open $name w]
  puts $file "\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\n\#"
  puts $file "\#  File:     $name"
  puts $file "\#  Created:  [exec date]"
  puts $file "\#  By:       $_program(id)"
  puts $file "\#\n"
  puts $file "_smVersion $_program(version)\
              $_require(driver) $_driver(version)"
  if {$which == "all"} {
    set m [_data(Count)]
    for {set i 0} {$i < $m} {incr i} {_file(_Write) $file $i}
  } else {
    _file(_Write) $file $_movie(id)
  }
  close $file
}

proc _file(_Write) {file i} {
  global _data
  set name [_data(FindName) $i]
  set data $_data($name)
  set script [lindex $data 0]
  set values [lindex $data 1]
  puts $file "\nMovie $name {"
  puts $file $script
  puts $file "} {"
  foreach item $values {puts $file "  {$item}"}
  puts $file "}"
}

proc _file(_Load) {name {clear none}} {
  global _file _movie _fname _program _driver
  if {![file exists $name]}   {Error "Can't find file '$name'"}
  if {![file readable $name]} {Error "Can't open '$name' for reading"}
  _fname(Close)
  if {$clear == "clear"} {
    _data(Clear)
    _data(RemoveEmpty)
    set name [_file(Name) $name]
  } else {
    _data(Save) $_movie(name)
    set _file(changed) 1
  }
#  set _file(dir) [file dirname $name]
  set _file(first) ""
  set code [uplevel \#0 [list catch "source $name" _file(message)]]
  set _file(version)  $_program(version)
  set _file(dversion) $_driver(version)
  if {[_data(Count)] == 0} _data(MakeUntitled)
  if {$_file(first) == ""} {set _file(first) [_data(FindName) 0]}
  _data(Select) $_file(first)
  switch $code {
    0 {} 2 {} 3 {} 4 {}
    1 {
      global errorInfo errorCode
      return -code error -errorinfo $errorInfo \
	  -errorcode $errorCode $_file(message)
    }
    default {return -code $code $_file(message)}
  }
}

proc _file(EarlierV) {V} {
  global _file
  set vv [split $V .]
  set vf [split $_file(version) .]
  set Mv [lindex $vv 0]; set mv [lindex $vv 1]
  set Mf [lindex $vf 0]; set mf [lindex $vf 1]
  return [expr $Mf < $Mv || ($Mf == $Mv && $mf < $mv)]
}

proc _smVersion {version {driver ""} {dversion 0.0}} {
  global _file _require
  set v [split $version .]
  set M [lindex $v 0]; set m [lindex $v 1]
  set _file(ignore) [expr $M < $_file(majorV) || \
			 ($M == $_file(majorV) && $m < $_file(minorV))]
  if {$driver != $_require(driver) && $driver != ""} {
    Error "Driver mismatch:  '$driver' should be '$_require(driver)'"
  }
  set _file(version)  $M.$m
  set _file(dversion) $dversion
  _driver(FileV) $dversion
}

proc Movie {name script {data {}}} {
  global _file _data _movie
  set name [_data(UniqueName) $name]
  if {$_file(first) == ""} {set $_file(first) $name}
  set script [string trim $script]
  if {$data == {} || $_file(ignore)} {set data [lindex $_movie(default) 1]}
  set _data($name) [_vcheck(All) [list $script $data]]
  _data(Insert) $name
}



proc _file(Name) {name} {
  global _file env
  if {[file dirname $name] != "."} \
      {cd [set env(PWD) [set _file(pwd) [file dirname $name]]]}
  set name [file tail $name]
  if {$name == ""} {set name $_file(default)}
  set _file(name) $name
  set _file(root) [file rootname $name]
  if {$_file(root) == ""} {set _file(root) .}
  _file(SetTitle)
  set _file(changed) 0
  return $name
}

proc _file(SetTitle) {} {
  global _file _program
  if {$_file(name) == $_file(default)} {
    wm title . $_program(id)
    .mbar.file.menu entryconfigure 3 -state disabled
  } else {
    wm title . "$_program(id): [file tail $_file(name)]"
    .mbar.file.menu entryconfigure 3 -state normal
  }
}

proc _file(Confirm) {action} {
  global _file _movie
  _data(Save) $_movie(name)
  if {! $_file(changed)} {return 0}
  Confirm "Warning:  Changes have not been saved.  $action anyway?"
}

proc _file(TrapExit) {} {
  catch {rename exit _file(exit)}
  proc exit {{code 0}} {
    global _program
    if [_file(Confirm) "Exit"] return
    puts "Message Kill"
    puts "Stop $_program(name)"
    flush stdout
    uplevel [list _file(exit) $code]
  }
}

_file(Name) $_file(default)

Require remove.tcl