proc _driver(GetActions) {} {}
proc _driver(GetFilenames) {} {}
proc _driver(CheckDirs) {} {}
proc _driver(CheckFiles) {} {}

set _execute(arrays) \
  {_action _options _frame _mpeg _animGIF _image _scenes _file _scene}
set _execute(vars)   {_movie(name)}
set _execute(procs)  {}
set _execute(text)   .script

set _action(preview) 1

proc _execute(Script) {{type new}} {
  global _execute
  if [_execute(CheckFiles) $type] return
  StageDoor "Start BackStage -sync"
  Input line
  if {$line != "BackStage started"} {Error "BackStage failed to start!"}
  StageDoor "Message Clear"
  StageDoor "Message Open"
  StageDoor "Message Cancel"
  _execute(Data)
  StageDoor "Message Execute"
}

proc _execute(Data) {} {
  _execute(Vars)
  _execute(Arrays)
  _execute(Procs)
  _execute(Text)
}

proc _execute(Text) {} {
  global _execute
  _command(Send) BackStage \
      [list set _program(script) [$_execute(text) get 0.0 end-1c]]
}


proc _execute(Arrays) {} {
  global _execute
  if {$_execute(arrays) != ""} {
    foreach array $_execute(arrays) {
      upvar \#0 [lindex $array 0] a;
      if {[llength $array] == 1} {set indices [lsort [array names a]]} \
	  else {set indices [lindex $array 1]}
      foreach index $indices {
	if {[string index $index 0] != "."} {
	  lappend command [list set $array\($index\) $a($index)]
	}
      }
    }
    _command(Send) BackStage [join $command \n]
  }
}

proc _execute(Vars) {} {
  global _execute
  if {$_execute(vars) != ""} {
    foreach var $_execute(vars) {
      upvar \#0 $var v
      lappend command [list set $var $v]
    }
    _command(Send) BackStage [join $command \n]
  }
}

proc _execute(Procs) {} {
  global _execute
  foreach proc $_execute(procs) {eval $proc}
}


proc _execute(CheckFiles) {{type new}} {
  global _file _action env
  _execute(GetActions)
  _execute(GetFilenames)
  if {!$_action(preview)}  {_execute(CheckDir) $_file(root)}
  if {$_action(frames)}    {_execute(CheckDir) $_file(frameroot)}
  if {$_action(snapshots)} {_execute(CheckDir) $_file(imageroot)}
  _driver(CheckDirs)
  if {$type != "mpeg"} {
    if [_execute(Confirm) $_action(mpeg) $_file(mpeg)] {
      _fname(NewFile) "Save mpeg movie as:" $_file(mpeg) \
	  {_execute(Mpeg) {%N}} .mpg $env(PWD)
      return 1
    }
  }
  if {$type != "animGIF"} {
    if [_execute(Confirm) $_action(animGIF) $_file(animGIF)] {
      _fname(NewFile) "Save Animated GIF movie as:" $_file(animGIF) \
	  {_execute(AnimGIF) {%N}} .gif $env(PWD)
      return 1
    }
  }
  _driver(CheckFiles)
  return 0
}

proc _execute(GetActions) {} {
  global _action
  set _action(preview) [expr ! \
     ($_action(frames) || $_action(snapshots) || \
      $_action(mpeg) || $_action(video) || $_action(animGIF))]
  set _action(driver) \
      [expr $_action(preview) || $_action(frames) || $_action(snapshots)]
  _driver(GetActions)
}

proc _execute(GetFilenames) {} {
  global _file _movie

  if {[info exists _file(base)] &&
      $_file(base) == "$_file(root)/$_movie(name)"} return

  set _file(base)      "$_file(root)/$_movie(name)"
  set _file(frameroot) "$_file(base)-frames"
  set _file(imageroot) "$_file(base)-snapshots"
  set _file(mpeg)      "$_file(base).mpg"
  set _file(param)     "$_file(base).param"
  set _file(animGIF)   "$_file(base).gif"
  set _file(video)     "$_file(base).heave"

  _driver(GetFilenames)
}

proc _execute(CheckDir) {name} {
  if [file exists $name] {
    if ![file isdirectory $name] \
	{Error "Can't create directory '$name' -- file exists"}
  } else {exec /bin/mkdir $name}
}

proc _execute(Confirm) {action file} {
  if {$action && [file exists $file]} {
    return [Confirm "File '$file' already exists:  Overwrite it?"]
  }
  return 0
}

proc _execute(Done) {name scenes} {
  global _movie _action
  if {$name == $_movie(name)} {
    foreach var $_movie(reset.actions) {set _action($var) 0}
    if {$scenes != ""} {_unpack(_Scene) $scenes}
  }
}

proc _execute(Mpeg) {name} {
  global _file
  set _file(mpeg) $name
  _fname(Close); update idletasks
  _execute(Script) mpeg
}

proc _execute(AnimGIF) {name} {
  global _file
  set _file(animGIF) $name
  _fname(Close); update idletasks
  _execute(Script) animGIF
}
