Require text.tcl
Require button.tcl
Require ctrl-k.tcl
Require option.tcl

set _message {          [Enter commands for BackStage]}


_option(Add) fontsize	  14 
_option(Add) maxlines	  500 
_option(Add) prompt	  ">" 
set _fontsize [option get . fontsize *]
set _maxlines [option get . maxlines *]
set _prompt   [option get . prompt *]

_option(Add) input(font)   "*-courier-medium-r-normal--$_fontsize-*" 
_option(Add) input(color)  black 
_option(Add) prompt(font)  "*-courier-medium-r-normal--$_fontsize-*" 
_option(Add) prompt(color) grey50 
_option(Add) output(font)  "*-courier-medium-o-normal--$_fontsize-*" 
_option(Add) output(color) black 
_option(Add) error(font)   "*-courier-medium-o-normal--$_fontsize-*" 
_option(Add) error(color)  red3 

_option(Add) Button.relief	groove 
_option(Add) Button.borderWidth	3 
_option(Add) Button.font   "*-helvetica-bold-r-normal--$_fontsize-*" 

_option(Add) commands.font [option get . input(font) *]

_text(Scrollable) . commands 50 12

_button(Box) . box left {
  {Action clear    _Clear    _window(Clear)    -width 8}
  {Action controls  Controls _window(Controls) -width 8}
  {Action quit     _Quit     _window(Exit)     -width 8}
}

.commands tag configure output \
    -font [option get . output(font) *] \
    -foreground [option get . output(color) *]
.commands tag configure input \
    -font [option get . input(font) *] \
    -foreground [option get . input(color) *]
.commands tag configure prompt \
    -font [option get . prompt(font) *] \
    -foreground [option get . prompt(color) *]
.commands tag configure error \
    -font [option get . error(font) *] \
    -foreground [option get . error(color) *]


proc _window(Clear) {} {
  global _prompt _message
  .commands delete 0.0 end
  .commands insert end "$_message\n" output
  _key(Prompt)
  .commands see insert
}

proc _window(Exit) {} {
  global _program
  _cmd(Start) BackStage
  set code [catch {_command(Send) BackStage {set _status(running)}} running]
  if {$code || !$running} {StageDoor "Message Kill"}
  StageDoor "Stop $_program(name)"
  exit
}

proc _window(Controls) {} {_cmd(Start) BackStage; StageDoor "Message Open"}