set _cmd(errorInfo) {}

proc _driver(Complete) {cmd} {return [info complete $cmd]}
proc _driver(Invoke)   {cmd} {_cmd(Send) $cmd}

proc _cmd(Start) {name} {
  StageDoor "Start $name -sync"; Input line
  if {$line != "$name started"} {return -code error "$name failed to start!"}
}

proc _cmd(Send) {cmd} {
  if {$cmd == ""} return
  _cmd(Start) BackStage
  _command(Send) BackStage [list _program(Receive) $cmd]
}

proc _cmd(Invoke) {} {
  global _cmd errorInfo
  set cmd [string trim [_key(GetInput) insert]]
  if [_driver(Complete) $cmd] {
    _key(CopyInput) $cmd insert
    .commands insert insert \n {input newline}
    .commands see insert; update idletasks
    if {[info procs _cmd(_[lindex $cmd 0])] == ""} {
      if {[llength $cmd] > 0} {set cmd [list _driver(Invoke) $cmd]}
    } else {
      set cmd [lreplace $cmd 0 0 _cmd(_[lindex $cmd 0])]
    }
    set code [catch $cmd result]
    switch $code {
      0 {if {$result != ""} {.commands insert insert "$result\n" output}}
      default {.commands insert insert "Error: $result\n" {error output}}
    }
    set _cmd(errorInfo) $errorInfo
    _key(CheckLines)
    _key(Prompt)
  } else {
    .commands insert insert \n input
  }
  .commands see insert
}

proc _cmd(_errorInfo) {} {
  global _cmd
  regsub "\n *invoked from within\n\"_status\\(Receive\\) \\\$script\".*" \
    $_cmd(errorInfo) {} line
  regsub "(\n *\\(\[^\n\]*\\))?\n *invoked from\
     within\n\"uplevel \\\\#0 \\\$script\".*" $line {} line
  .commands insert insert "ErrorInfo: $line\n" {error output}
}

proc _cmd(_StageHand) {script} {uplevel \#0 $script}