Require IO.tcl

Require text.tcl
Require button.tcl
Require option.tcl

set _msg(process) ""

_option(Add) message(font) "*-courier-medium-r-normal--*-140-*" 
set _message(font) [option get . message(font) *]

_option(Add) msg.text.maxlines 1000 
_option(Add) msg.text.color(error) red3 
_option(Add) msg.text.color(message) black 
_option(Add) msg.text.color(print) blue3 
_option(Add) msg.text.font $_message(font) 
_option(Add) msg.title.font $_button(font) 
_option(Add) msg.text.indent 10 

#_option(Add) msg.frame.relief groove 
#_option(Add) msg.frame.box.borderWidth 3 

toplevel .msg
wm withdraw .msg
wm title .msg "$_program(id): Execution Control"
wm minsize .msg 400 180


label .msg.title -text "Messages:"
pack .msg.title -side top -fill x

_text(Scrollable) .msg text 45 8 
.msg.text configure -state disabled

_button(Box) .msg bbox left {
  {Action step     Step     _msg(_Step)     -state disabled}
  {Action continue Continue _msg(_Continue) -state disabled}
  {Action pause    Pause    _msg(_Pause)    -state disabled}
  {Action cancel   Cancel   _msg(_Cancel)   -state disabled}
  {Action kill     Kill     _msg(_Kill)     -state disabled}
  {Action close    Close    _msg(_Close)}
}

.msg.text tag configure error \
   -foreground [option get .msg.text color(error) *] \
   -lmargin2 [option get .msg.text indent *]
.msg.text tag configure message \
   -foreground [option get .msg.text color(message) *] \
   -lmargin2 [option get .msg.text indent *]
.msg.text tag configure print \
   -foreground [option get .msg.text color(print) *] \
   -lmargin2 [option get .msg.text indent *]



proc _msg(_Configure) {states title} {
  _msg(_Buttons) $states
  _msg(_Title) $title
}

proc _msg(_Buttons) {states} {
  set buttons {step continue pause cancel kill close}
  for {set i 0} {$i < [llength $states]} {incr i} {
    if {[lindex $states $i] != ""} {
      .msg.bbox.[lindex $buttons $i] configure -state [lindex $states $i]
    }
  }
}

proc _msg(_Title) {title} {.msg.title configure -text $title}

proc _msg(_Open) {} {
  if {[winfo ismapped .msg]} {wm iconify .msg}
  wm deiconify .msg
  tkwait visibility .msg
}

proc _msg(_Close) {} {wm withdraw .msg}

proc _msg(_Pause) {} {
  _IO(Status) Pause
  _msg(_Buttons) {normal normal disabled}
}
proc _msg(_Continue) {} {_IO(Status) Continue}
proc _msg(_Step)     {} {_IO(Status) Step}
proc _msg(_Cancel)   {} {_IO(Status) Cancel}
proc _msg(_Execute)  {} {_IO(Status) Execute}

proc _msg(_Kill) {} {
  global _msg
  catch {_IO(Status) Kill}
  _msg(_Configure) \
     {disabled disabled disabled disabled disabled} "Messages:"
  if {$_msg(process) != ""} {
    set proc $_msg(process)
    if {[info procs "_$proc\(Stop)"] == ""} {
      _IO(Kill) $proc
      _IO(Died) $proc
    } else {
      _$proc\(Stop\)
      _IO(Died) $proc
    }
  }
  _msg(_Close)
}

proc _msg(_Clear) {} {
  .msg.text configure -state normal
  .msg.text delete 1.0 end
  .msg.text configure -state disabled
  update idletasks
}

proc _msg(_Print) {n {tags "print"}} {
  upvar name name
  _msg(Print) [_IO(Read) $name $n] $tags
}

proc _msg(Print) {line {tags "print"}} {
  set maxlines [option get .msg.text maxlines *]
  .msg.text configure -state normal
  if {[.msg.text index end] > $maxlines} {
    set i [expr int([.msg.text index end]) - $maxlines]
    .msg.text delete 1.0 "1.0 + $i lines"
  }
  if {[.msg.text compare insert > 1.0]} {.msg.text insert end \n}
  .msg.text insert end $line $tags
  .msg.text see end
  .msg.text configure -state disabled
  update idletasks
}

proc _msg(_Error) {n} {
  upvar name name
  set line [_IO(Read) $name $n]
  if {! [winfo ismapped .msg]} {wm deiconify .msg}
  _msg(Print) "\n=== Error: =================" error
  set end [.msg.text index end]
  _msg(Print) $line error
  _msg(Print) "----------------------------" error
  .msg.text see $end
}

proc _msg(_Select) {{title ""} {module ""}} {
  global _msg
  set name [uplevel set name]
  if {$name == "stdin" && $module != ""} {set name $module}
  if {$title == ""} {set title "$name: Started"}
  if {$name != "stdin"} {
    set _msg(process) $name
    _msg(_Configure) {{} {} {} {} normal} "$title"
  }
}


proc _IO(_Message) {name cmd args} {
  if {[info procs _msg(_$cmd)] != ""} {eval _msg(_$cmd) $args} \
      else { _IO(Error) "bad Message command '$cmd'"}
}

proc _IO(Status) {code} {
  global _msg
  if {$_msg(process) != ""} {
    _IO(Print) $_msg(process) "<< Status: $code >>"
  } else {_IO(Error) "No current backend process"}
}
