Require bind.tcl
Require quote.tcl
Require error.tcl
Require confirm.tcl

proc _driver(Print) {name args} {}
proc _driver(Tell) {name line} {}
proc _driver(Ask) {name tag line} {}
proc _driver(Kill) {proc} {}

proc _IO(Handler) {name} {
  global _IO
  if ![info exists _IO($name.file)] return
  if {[gets $_IO($name.file) line] == -1} {_IO(Died) $name}
  if {[catch {llength $line} len]} {
    _IO(Catch) _IO(Error) "missing closing brace or quote in '$line'"
  } elseif {$len > 0} {
    _IO(Catch) eval \
	_IO(_[lindex $line 0]) $name [_QuoteCMD [lrange $line 1 end]]
  }
}

proc _IO(StartHandler) {} {
  global _IO
  fileevent stdin read {_IO(Handler) stdin}
  set _IO(stdin.file) stdin
}
proc _IO(StopHandler) {} {fileevent stdin read {}}


proc _IO(_Send) {name to id n args} {
  global _IO
  if [catch {_bind(Rest) {{module ""}} {{timeout= 60} {!confirm 0 1 1}} \
		 $args _IO(_Send)} message] {return -code error $message}
  if {$module != "" && [info exists _IO($module.module)]} {set name $module}
  set command [_IO(Read) $name $n]
  if {[info exists _IO($to.file)]} {
    if {$id != ""} {set _IO($to.$name.$id) {}}
    _IO(Print) $to "<< Command: [list $name $id $n] >>" $command
    if {$timeout > 0} {
      set _IO(after:$to.$name.$id) \
	  [after [expr $timeout*1000] \
	       [list _IO(Cancel) $to $name $id $timeout $confirm]]
    }
  } else {
    set message "No pipe to '$to'"
    set mlen [string length $message]
    _IO(Print) $name \
	"<< Reply: [list $to $id error IO_NOPIPE $mlen 0] >>" \
	$message {}
    _IO(Error) $message
  }
}

proc _IO(_Reply) {name from id code ecode mlen elen {module ""}} {
  global _IO
  if {$module != "" && [info exists _IO($module.module)]} {set name $module}
  set message [_IO(Read) $name $mlen]
  set einfo [_IO(Read) $name $elen]
  if {[info exists _IO($from.file)]} {
    catch {after cancel $_IO(after:$name.$from.$id)}
    catch "unset _IO($name.$from.$id); unset _IO(after:$name.$from.$id)"
    _IO(Print) $from \
	"<< Reply: [list $name $id $code $ecode $mlen $elen] >>" \
	$message $einfo
  } else {_IO(Error) "No pipe to '$from'"}
}

proc _IO(Cancel) {to from id timeout {confirm 1}} {
  global _IO
  if [info exists _IO($to.$from.$id)] {
    if {!$confirm || ($confirm &&
        [Confirm "Process '$to' has not responded in $timeout seconds. \
                  Continue to wait?"])} {
      unset _IO(after:$to.$from.$id); unset _IO($to.$from.$id)
      set message "Process '$to' did not respond in $timeout seconds"
      set len [string length $message]
      _IO(Print) $from "<< Reply: [list $to] $id 1 NONE $len $len >>" \
	  $message $message
    } else {
      set timeout [expr int(1.5*$timeout)]
      set _IO(after:$to.$from.$id) \
	[after [expr $timeout*1000] \
	     [list _IO(Cancel) $to $from $id $timeout $confirm]]
    }
  } else {catch "unset _IO(after:$to.$from.$id)"}
}

proc _IO(Read) {name n} {
  global _IO
  set line {}
  if {[info exists _IO($name.file)]} {
    set pipe $_IO($name.file); if {$pipe == "stdout"} {set pipe "stdin"}
    set line [read $pipe $n]; read $pipe 1
  } else {_IO(Error) "Unknown pipe '$name'"}
  return $line
}

proc _IO(Print) {name args} {
  global _IO
  if {![info exists _IO($name.file)]} return
  set pipe $_IO($name.file)
  if {$pipe == "stdin"} {set pipe stdout}; #  hack!
  if {$pipe != "stdout"} {
    foreach line $args {puts $pipe $line}
    if [catch {flush $pipe}] {_IO(Died) $name}
  } else {
    if {[info exists _IO($name.module)]} {
      eval [list _driver(Print) $name] $args
    } else {_IO(Error) "Module '$name' not registered"}
  }
}

proc _IO(_Sync) {name} {_IO(Print) $name "Sync"}


proc _IO(_Register) {name module {emodule ""}} {
  global _IO
  if {$emodule == ""} {
    _IO(Died) $module
  } elseif {![info exists _IO($module.module)]} {
    set _IO($module.module) $emodule
    set _IO($module.file) stdout
  }
}


proc _IO(_Tell) {name n} {
  set line [_IO(Read) $name $n]
  _driver(Tell) $name $line
}

proc _IO(_Ask) {name n {tag {<< Route End >>}}} {
  set tag [_Quote $tag];
  set line [_IO(Read) $name $n]
  _driver(Ask) $name $tag $line
}


proc _IO(_Route) {name to {tag {<< Route End >>}}} {
  global _IO
  gets stdin line
  if {[info exists _IO($to.file)]} {
    while {$line != $tag} {
      _IO(Print) $to $line
      gets stdin line
      # do something here to prevent blocking ###
    }
    flush $_IO($to.file)
  } else {
    _IO(Error) "No pipe for '$to'"
    while {$line != $tag} {gets stdin line}
    # do something here to prevent blocking ###
  }
}


proc _IO(_Start) {name proc args} {
  global _IO
  if [catch {_bind(Flags) {!sync} $args _IO(_Start)} message] \
      {return -code error $message}

  if {[info exists _IO($proc.file)]} {
    if {$sync} {_IO(Print) $name "$proc started"}
    return
  }
  if {[info procs _${proc}(Start)] != ""} {
    set cmd "set _IO($proc.file) \[_${proc}(Start)\]"
    if {!$sync} {after 0 $cmd} else \
	{after 0 [list _IO(SyncStart) $name $proc $cmd]}
  } else {_IO(Error) "Don't know how to start '$proc'"}
}

proc _IO(SyncStart) {name proc cmd} {
  if [catch $cmd] {_IO(Print) $name "$proc died"} \
      else {_IO(Print) $name "$proc started"}
}

proc _IO(_Stop) {name proc} {
  global _IO
  if {[info exists _IO($proc.file)]} {
    if {[info procs _${proc}(Stop)] == ""} {
      after 0 "_IO(Kill) $proc; _IO(Died) $proc"
    } else {
      after 0 "_${proc}(Stop); _IO(Died) $proc"
    }
  }
}

proc _IO(_Exit) {name {code 0}} {
  global _IO
  foreach file [array names _IO *.file] {
    if {$_IO($file) != "stdin" && $_IO($file) != "stdout"} {
      set file [file rootname $file]
      _IO(Kill) $file; _IO(Died) $file
    }
  }
  exit $code
}

proc _IO(Kill) {proc} {
  global _IO
  if [info exists _IO($proc.module)] {
    _driver(Kill) $_IO($proc.module)
  } elseif [info exists _IO($proc.file)] {
    set pipe $_IO($proc.file)
    catch "exec /bin/kill [pid $pipe]"
  }
}

proc _IO(Died) {proc} {
  global _IO
  foreach var [array names _IO "after:$proc.*"] \
      {unset _IO($var); after cancel _IO($var)}
  foreach var [array names _IO "$proc.*.*"] {
    _Bind {to from id} [split $var {.}]
    if {[info exists _IO($from.file)]} {
      _IO(Print) $from "<< Reply: $proc $id 1 NONE 36 36 >>" \
	  "Process died while waiting for reply" \
	  "Process died while waiting for reply"
    }
    unset _IO($var)
  }
  foreach var [array names _IO(*.$proc.*)] {unset _IO($var)}
  if [info exists _IO($proc.ready)] {set _IO($proc.ready) -1}
  if [info exists _IO($proc.file)] {
    if {$_IO($proc.file) != "stdin" && $_IO($proc.file) != "stdout"} {
      fileevent $_IO($proc.file) readable {}
      catch {close $_IO($proc.file)}
    }
    catch {unset _IO($proc.file); unset _IO($proc.module)}
  }
  foreach file [array names _IO *.file] {
    set proc [file rootname $file]
    if {$file != "stdin.file" && ![info exists _IO($proc.module)]} return
  }
  exit
}

proc _IO(Run) {proc args} {
  global _require _IO
  if [catch {_bind(Flags) {!sync {timeout= 30}} $args _IO(Run)} message] \
      {return -code error $message}
  set file "$_require(root)/module/$proc/$proc $_require(driver)"
  set pipe [open "| $file 2>@stderr" r+]
  fileevent $pipe read [list _IO(Handler) $proc]
  if {$sync} {
    set _IO($proc.file) $pipe
    set _IO($proc.ready) 0
    if {$timeout > 0} {
      set timeout [expr $timeout * 1000]
      set _IO(after:$proc) [after $timeout [list _IO(_NotReady) $proc]]
    }
    tkwait variable _IO($proc.ready)
    set code $_IO($proc.ready); unset _IO($proc.ready)
    catch {after cancel $_IO(after:$proc); unset _IO(after:$proc)}
    if {$code == -1} {
      _IO(Kill) $proc; _IO(Died) $proc
      _IO(Error) "Process \"$proc\" did not start properly"
    }
  }
  return $pipe
}

proc _IO(_Ready) {name} {global _IO; set _IO($name.ready) 1}
proc _IO(_NotReady) {name} {global _IO; set _IO($name.ready) -1}


proc _IO(Catch) {args} {
  set code [catch $args message]
  if {$code == 1} {
    _error(Message) $message
    set message [concat "StageDoor Error: " $message]
    puts stderr $message
  } else {
    return -code $code $message
  }
}

proc _IO(Error) {message} {return -code error -errorcode MYERROR $message}

proc _IO(_Shell) {name} \
  {global _program; Require shell.tcl; TclShell "$_program(id): Shell"}
