Require menu.tcl
Require text.tcl
Require button.tcl
Require ctrl-k.tcl
Require option.tcl

_option(Add) Button.relief	groove
_option(Add) Button.borderWidth	3

_option(Add) mbar.type.foreground blue3
_option(Add) mbar.update.foreground blue3
_option(Add) mbar.update.font "*-symbol-medium-r-normal--14-*"
_option(Add) mbar.update(char) 0xA8

_menu(Bar) . mbar {

  _File file {
    {Action _New 	      {_File New}}
    {Action _Open...          {_File Open}}
    {Action _Save             {_File Save}}
    {Action "Save _As..."     {_File SaveAs}}
    {Action _Revert           {_File Revert}}
     Line
    {Action _Import...        {[_Current] Import}}
    {Action _Export...        {[_Current] Export}}
    {Action "Save OO_GL..."   {[_Current] SaveOOGL}}
     Line
    {Action _Libraries...     {_Library Request}}
     Line
    {Action _Quit 	   exit}
  }

  _Edit edit {
    {Action Cut    _edit(Cut)   Ctrl-W}
    {Action _Copy  _edit(Copy)  ESC-W}
    {Action _Paste _edit(Paste) Ctrl-Y}
     Line
    {Action Clear  _edit(Clear) BS}
     Line
    {Menu 
      Preferences prefs {
        {Check "Use old 'let'" _expr(useOldLet)}
      }
    }
  }

  _Object object {
    {Action _New...             {[_Current] New}}
    {Action _Add...             {[_Current] AddNew} {} -state disabled}
    {Action _Rename...          {[_Current] Rename}}
    {Action _Duplicate...       {[_Current] Duplicate}}
    {Action  Delete             {[_Current] Delete}}
     Line
    {Menu   _Template template {} {} -state disabled}
     Line
    {Action "_Link To..."       {[_Current] LinkTo}}
    {Action "Move To _Group..." {[_Current] MoveToGroup}}
    {Action "Remove _From Group" {[_Current] RemoveFromGroup} \
        {} -state disabled}
     Line
    {Menu
      _Update update {
	{Action _Definition     {[_Current] Define}}
	{Action _Colors         {[_Current] HandleColor}}
	{Action _Appearance     {[_Current] HandleAppearance}}
	{Action _Object         {_button(Invoke) .bbox.update}}
	 Line
	{Check Automatic       _object(autoUpdate) {_File Changed 1} checked}
      }
    }
    {Menu 
      _Show show {
	{Radio _Always          _object(status) always   {[_Current] Status} 1}
	{Radio "When _Selected" _object(status) selected {[_Current] Status}}
        {Radio _Never           _object(status) hide     {[_Current] Status}}
      }
    }
    {Menu
      _Normalize normalize {
	{Action _Again {[_Current] Normalize again}}
	 Line
	{Radio _None _object(normalize) none  {[_Current] Normalize}}
	{Radio _Keep _object(normalize) keep  {[_Current] Normalize} 1}
	{Radio _Each _object(normalize) each  {[_Current] Normalize}}
	{Radio A_ll  _object(normalize) all   {[_Current] Normalize}}
      }
    }
  }

  _Color color {
    {Menu "by _Parameter" parameter {} {} -state disabled}
    {Menu "by _Coordinate" coordinate {
      {Radio x _color(by) {set x} {[_Current] AutoColor}}
    }}

    {Menu "by _Function" function {} {} -state disabled}
    {Menu _Solid solid {
      {Radio _None _color(by) { } {[_Current] AutoColor} checked}
      Line
      Line
      {Radio "_Other..." _color(by) {other} {[_Current] Color Other}}
    }}
     Line
    {Check _Normalize     _color(normalize)  {[_Current] AutoColor} checked}
    {Check "_Wrap Colors" _color(wrap)       {[_Current] AutoColor}}
     Line
    {Check "_Inherit Colors" _color(inherit) {[_Current] Color Inherit}}
    {Action "_Edit Colors..." {_ColorEdit Request}}
  }

  _Appearance appearance {
    {Menu
      _Shading shading {
	{Radio _Constant _app(shading) constant {[_Current] AutoApp}}
	{Radio _Flat     _app(shading) flat     {[_Current] AutoApp} checked}
	{Radio _Smooth   _app(shading) smooth   {[_Current] AutoApp}}
	{Radio _CSmooth  _app(shading) csmooth  {[_Current] AutoApp}}
      }
    }
    {Menu
      _Transparency trans {
	{Radio "  0% (opaque)"      _app(trans) 1.0  {[_Current] AutoApp} 1}
	{Radio " 25%"               _app(trans) 0.75 {[_Current] AutoApp}}
	{Radio " 33%"               _app(trans) 0.67 {[_Current] AutoApp}}
	{Radio " 50%"               _app(trans) 0.5  {[_Current] AutoApp}}
	{Radio " 67%"               _app(trans) 0.33 {[_Current] AutoApp}}
	{Radio " 75%"               _app(trans) 0.25 {[_Current] AutoApp}}
	{Radio "100% (transparent)" _app(trans) 0.0  {[_Current] AutoApp}}
	 Line
	{Radio "_Other..." _app(trans) {other} \
	     {[_Current] Appearance Transparency}}
      }
    }
    {Menu
      "_Line Width" width {
	{Radio " 0" _app(lineW)  0 {[_Current] AutoApp}}
	{Radio " 1" _app(lineW)  1 {[_Current] AutoApp} checked}
	{Radio " 2" _app(lineW)  2 {[_Current] AutoApp}}
	{Radio " 3" _app(lineW)  3 {[_Current] AutoApp}}
	{Radio " 4" _app(lineW)  4 {[_Current] AutoApp}}
	{Radio " 5" _app(lineW)  5 {[_Current] AutoApp}}
	{Radio " 7" _app(lineW)  7 {[_Current] AutoApp}}
	{Radio "10" _app(lineW) 10 {[_Current] AutoApp}}
	{Radio "15" _app(lineW) 15 {[_Current] AutoApp}}
	 Line
	{Radio "_Other..." _app(lineW) {other} \
	     {[_Current] Appearance LineWidth}}
      }
    }
    Line
    {Check _Faces   _app(faces)       {[_Current] AutoApp} checked}
    {Check _Edges   _app(edges)       {[_Current] AutoApp}}
    {Check _Normals _app(normals)     {[_Current] AutoApp}}
    Line
    {Menu
      _Inherit inherit {
	{Check _Shading      _app(iShading)       {[_Current] AutoApp}}
	{Check _Transparency _app(iTransparency)  {[_Current] AutoApp}}
	{Check "_Line Width" _app(iLineWidth)     {[_Current] AutoApp}}
	{Check _Edges        _app(iEdges)         {[_Current] AutoApp}}
	{Check _Faces        _app(iFaces)         {[_Current] AutoApp}}
	{Check _Normals      _app(iNormals)       {[_Current] AutoApp}}
	Line
	{Action _All  {[_Current] Appearance Inherit 1 1; [_Current] AutoApp}}
	{Action _None {[_Current] Appearance Inherit 0 1; [_Current] AutoApp}}
      }
    }
  }

  >> _Help help {
    {Action "_About..."     _help(About)}
    {Action "_Browser..."   _help(Browser)}
  }
}
foreach menu [pack slaves .mbar] {catch {$menu configure -state disabled}}

_option(Set) .mbar.type font $_menu(font)
label .mbar.type -textvariable _object(type)
label .mbar.update -textvariable _object(update)
frame .mbar.spacer -relief flat -bd 0 -width 10
pack .mbar.spacer .mbar.type .mbar.update -side right
set _object(updateChar) [format "%c" [option get .mbar update(char) *]]


_button(Box) . bbox top \
    {{Action update _Update {[_Current] Update}}} right
.bbox.update configure -state disabled
_button(Box) . bbox bottom {{Action quit _Quit exit}}
_menu(Scrollable) .bbox names "Objects:" 15 3
_text(Scrollable) . definition 45 10 1 top 1
_ctrlK(Bind) .definition

bind .definition <KP_Enter> {[_Current] Define}
bind .definition <Shift-KP_Enter> {_button(Invoke) .bbox.update}

wm minsize . 400 200
