Require oo.tcl

ooRoot Subclass Widgets {
  Var widgets current()
  ClassVar window part

  Method Window {title {w 200} {h 10}} {
    Vars window
    global _program
    toplevel $window
    wm withdraw $window
    wm title $window "$_program(id): $title"
    wm minsize $window $w $h
  }

  Method Init {} {set [var widgets] {}}
  Method Add {widget} {lappend [var widgets] $widget}

  Method Save {} {}
  Method Restore {{add 0} {base ""}} {
    Vars window part
    if {$add} {if [Owner isTop] return} else \
	{foreach widget [pack slaves $window] {pack forget $widget}}
    set group [Owner Group]
    $group $part Restore 1
    Self AddWidgets $add $base
    if {$add == 0} {
      Self DestroyOld
      if {[pack slaves $window] == ""} {wm withdraw $window} \
        else {if ![winfo ismapped $window] {wm deiconify $window}}
    }
  }

  Method AddWidgets {add base} {
    Vars widgets current part
    set self [Self]
    foreach widget $widgets {
      set name [lindex $widget 0]
      if [info exists current($name)] {
	eval [list Self $name Configure] [lrange $widget 1 end]
      } else {
	eval [list $part Instance $self] $widget
	set current($name) 1
      }
      Self $name BaseName $base
    }
    if {!$add && [Owner get type] == "Group"} \
      {Owner RestoreParts $base $part}
  }

  Method DestroyOld {} {
    Vars widgets current
    foreach widget [Self GetNames $widgets] {set w($widget) 1}
    foreach widget [array names current] {
      if ![info exists w($widget)] {
	Self $widget Destroy
	unset current($widget)
      }
    }
  }

  Method GetNames {widgets} {
    set list {}
    foreach widget $widgets {lappend list [lindex $widget 0]}
    return $list
  }

  Method Destroy {} {
    foreach widget [array names [var current]] {Self $widget Destroy}
    Parent Destroy
  }

  Method ComputeInit {} {
    Vars current part
    if [Owner isTop] return
    uplevel [list [Owner Group] $part ComputeInit]
    foreach widget [array names current] \
	{uplevel [list set $widget [Self $widget Get]]}
  }
}

ooRoot Subclass Widget {
  Var name

  Method Update {} {
    global _object _button errorInfo errorCode
    if {!$_object(autoUpdate)} {
      _Object NeedsUpdate [Owner Owner]
      return
    }
    set button .bbox.update
    set relief [$button cget -relief]
    if [info exists _button(invoke.$relief)] {
      $button configure -relief $_button(invoke.$relief)
      update idletasks
    }
    set code [uplevel \#0 [list catch "Owner Owner Update 0" _button(err)]]
    $button configure -relief $relief
    return -code $code -errorinfo $errorInfo -errorcode $errorCode \
	$_button(err)
  }

  Method Set {value {update true}} {
    [val window].x-[Self] set $value
    if {$update == "true"} {Self Update}
  }
  Method Get {} {[val window].x-[Self] get}

  Method Instance {object name args} {
    Vars window
    set fullname [-oo(PartName) $object $name]
    Parent Instance $fullname
    $fullname set name $name
    eval [list $fullname Create $name] $args
  }

  Method Create {fullname name args} {}
  Method Configure {args} {}
  Method Remove {widget} {}
  Method BaseName {base} {}

  Method Destroy {} {
    Self Remove [val window].x-[Self]
    Parent Destroy
  }
}