Require label.tcl
Require button.tcl
Require widgets.tcl

Widgets Subclass TypeIns {
  ClassVar {window .typeins} {part TypeIn}
  ClassVar init()

  Method Restore {{add 0} {base ""}} {
    Vars window init
    foreach id [array names init] {unset init($id)}
    Parent Restore $add $base
    Self FixLabelWidths
    if {$add == 0} {
      if {![winfo exists ${window}.reset]} \
       {_button(Button) $window bottom Action reset _Reset {TypeIns Reset}}
      if {[winfo ismapped $window]} {pack ${window}.reset -fill x} \
       else {pack forget ${window}.reset}
    }
  }

  Method FixLabelWidths {} {
    Vars window
    set W 0; set titles {}
    foreach typein [pack slaves $window] {
      regsub {\(frame\)$} $typein {(title)} typein
      lappend titles $typein
      set w [string length [$typein cget -text]]
      if {$w > $W} {set W $w}
    }
    foreach typein $titles {$typein configure -width $W}
  }

  Method Reset {} {
    Vars init
    foreach id [array names init] {$id Set $init($id) 0}
    [_Current] Update
  }
}
TypeIns Window Type-Ins

Widget Subclass TypeIn {
  Var value type
  ClassVar {window .typeins}

  Method Set {value {update true}} {
    set [var value] $value
    if {[val type] == "text"} {
      set typein .typeins.x-[Self]
      $typein delete 0.0 end
      $typein insert 0.0 $value
    }
    if {$update == "true"} {Self Update}
  }

  Method Get {} {
    set typein .typeins.x-[Self]
    if {[val type] != "text"} {return [$typein get]} \
      else {return [string trim [$typein get 0.0 end]]}
  }

  Method BaseName {base} {
    if {$base != ""} {
      set typein .typeins.x-[Self](title)
      set name [string range [$typein cget -text] 1 end]
      $typein configure -text " $base$name"
    }
  }

  Method Create {name val lines w title} {
    Vars init value type
    set self [Self]
    set value $val
    TypeIns set init($self) $val
    if {$w == ""} {set w 15}
    if {$title == ""} {set title $name}
    if {$lines == ""} {
      set type "entry"
      set typein [_label(Entry) .typeins x-$self " $title:" [var value] $w]
      pack configure $typein -expand 1 -fill x
      bind $typein <Return> "$self Update"
      bind $typein <KP_Enter> "$self Update"
    } else {
      set type "text"
      set typein [_label(Text) .typeins x-$self " $title:" $w $lines 0]
      ${typein}(frame) configure -borderwidth 0 -relief flat
      bind $typein <KP_Enter> "set [var value] \[$self Get\]; $self Update"
      $typein insert 0.0 $val
    }
  }

  Method Configure {init lines w title} {
    Vars type name
    global _label
    set self [Self]
    set typein .typeins.x-$self

    if {($type == "text" && $lines == "") ||
        ($type == "entry" && $lines != "")} {
      Self Remove $typein
      Self Create $name $init $lines $w $title
    } else {
      TypeIns set init($self) $init
      if {$w == ""} {set w 15}
      $typein configure -width $w
      if {$title == ""} {set title $name}
      ${typein}(title) configure -text " $title: "
      pack ${typein}(frame) -in .typeins \
        -fill x -padx $_label(padx) -pady $_label(pady)
      if {[val type] == "text"} {
        $typein configure -height $lines
        pack configure ${typein}(frame) -fill both -expand 1
      }
    }
  }

  Method Remove {typein} {
    destroy $typein
    destroy ${typein}(frame)
    destroy ${typein}(title)
    catch {
      destroy ${typein}(scroll)
      destroy ${typein}(box)
    }
  }
}
