Require widgets.tcl
Require option.tcl

_option(Add) slider(font)  "*-helvetica-bold-r-normal--*-140-*" 
set _slider(font)  [option get . slider(font) *]

_option(Add) Scale.font	$_slider(font) 
_option(Add) sliders.Scale.length 300 
_option(Add) sliders.Frame.relief raised 
_option(Add) sliders.Frame.borderWidth 2 

Widgets Subclass Sliders {ClassVar {window .sliders} {part Slider}}
Sliders Window Sliders

Widget Subclass Slider {
  Var init base title
  ClassVar {window .sliders}

  Method Slide {value} {
    set slider .sliders.x-[Self]
    $slider configure -label "[val base]: $value"
  }

  Method BaseName {base} {
    set [var base] "$base[val title]"
    set slider .sliders.x-[Self]
    $slider configure -label "[val base]: [$slider get]"
  }

  Method Create {name min max init res ticks digits title} {
    if {$init == ""} {set init $min}
    if {$title == ""} {set title $name}
    set [var title] $title
    set self [Self]
    set [var init] $init
    set slider .sliders.x-$self
    frame $slider-box
    button $slider-reset -text "Reset" -command "$self Set $init"
    scale $slider -showvalue 0 -resolution $res -label "$name: $init" \
	-from $min -to $max -orient horizontal -tickinterval $ticks \
	-command "$self Slide"
    if {$digits != ""} {$slider configure -digits $digits}
    $slider set $init
    bind $slider <Any-ButtonRelease> "$self Update"
    pack $slider-reset -in $slider-box -side right -fill y
    pack $slider -in $slider-box -anchor center -fill both -expand 1
    pack $slider-box -in .sliders -ipadx 2 -ipady 2 -fill both -expand 1
  }

  Method Configure {min max init res ticks digits title} {
    if {$title == ""} {set title [val name]}
    set [var title] $title
    set slider .sliders.x-[Self]
    $slider configure -from $min -to $max -resolution $res -tickinterval $ticks
    if {$digits != ""} {$slider configure -digits $digits}
    pack $slider-box -in .sliders -ipadx 2 -ipady 2 -fill both -expand 1
  }

  Method Remove {slider} {
    destroy $slider
    destroy $slider-box
    destroy $slider-reset
  }
}
