Require oo.tcl
Require packdata.tcl

PackData Subclass ReferenceData {
  Var id ref referrer()
  ClassVar computed() inited() object() 
  ClassVar convert() fixref {loading 0} group
  ClassVar {default {{} {}}}
  ClassVar {data {id ref}}

  Method Object {} {
    Vars object ref
    if {$ref == "" || ![info exists object($ref)]} {return _NOOP}
    return $object($ref)
  }
  Method Set {name {internal 0}} {
    Vars object ref loading
    if {$loading && !$internal} return
    if {$name == ""} {Self Clear} else {
      Self Unset
      catch {set ref [$name Reference Add [Owner]]}
    }
  }
  Method Clear {} {
    Vars id object
    Self Unset
    catch {unset object($id)}
    set id ""
  }
  Method Unset {} {
    Vars ref object
    if {$ref != ""} {
      catch {$object($ref) Reference Remove [Owner]}
      set ref {}
    }
  }
  Method Add {name} {
    Vars referrer object id
    set referrer($name) 1
    if {$id == ""} {
      set id [Self GetID]
      set object($id) [Owner]
    }
    return $id
  }
  Method Remove {name} {
    Vars referrer object id
    catch {unset referrer($name)}
    if {[llength [array names referrer] == 0} {
      catch {unset object($id)}
      set id {}
    }
  }
  Method GetID {} {
    Vars object
    set olist [concat -1 [lsort [array names object]]]
    lappend olist [expr [lindex $olist end] + 2]
    set i 0
    while {[lindex $olist $i] == [lindex $olist [expr $i+1]] - 1} {incr i}
    return [expr [lindex $olist $i] + 1]
  }
  
  Method LoadBegin {{object ""}} {
    Vars group
    if {$object != "" || $group == ""} {
      Vars loading fixref convert
      unset convert; set convert() {}; unset convert()
      set fixref {}
      set group $object
      set loading 1
    }
  }
  Method LoadEnd {{object ""}} {
    Vars loading fixref convert group
    if {$group == $object} {
      set loading 0
      foreach object $fixref {
        set ref [$object Reference get ref]
        $object Reference set ref ""
        if [info exists convert($ref)] {
          $object Reference Set $convert($ref)
          catch [list uplevel \#0 $object HandleScript]
        } else {
          ConfirmOK "Warning:  '$object' refers to a non-existent object"
        }
      }
      unset convert; set convert() {}; unset convert()
      set fixref {}
      set group ""
    }
  }

  Method Unpack {list} {
    Vars id ref loading group convert fixref object
    Parent Unpack $list
    if {$group != ""} {
      if {$id != ""} {set convert($id) [Owner]; set id ""}
      if {$ref != ""} {
        set obj [string range $object($ref) 0 [string length $group]]
        if {[string compare "$group/" $obj] == 0} {
	  if ![info exists convert($ref)] {lappend fixref [Owner]} \
            else {set obj $convert($ref); set ref ""; Self Set $obj 1}
        } else {
          set obj $object($ref); set ref ""; Self Set $obj 1
        }
      }
    } elseif {$loading} {
      if {$id != ""} {set convert($id) [Owner]; set id ""}
      if {$ref != ""} {
	if ![info exists convert($ref)] {lappend fixref [Owner]} \
          else {set obj $convert($ref); set ref ""; Self Set $obj 1}
      }
    } else {set id {}; set ref {}}
  }

  Method Duplicate {old} {
    if {[val group] == "" && [set object [$old Reference Object]] != "_NOOP"} \
      {Self Set $object}
  }
  Method Rename {old} {
    Vars object id ref referrer
    upvar \#0 [$old Reference var id] oldID
    upvar \#0 [$old Reference var ref] oldRef
    upvar \#0 [$old Reference var referrer] oldReferrer
    set new [Owner]
    set id $oldID; set oldID {}
    set ref $oldRef; set oldRef {}
    foreach reference [array names oldReferrer] \
      {set referrer($reference) $oldReferrer($reference)}
    if {$id != ""} {set object($id) $new}
    if {$ref != ""} {
      upvar \#0 [$object($ref) Reference var referrer($old)] refRef
      $object($ref) Reference set referrer($new) $refRef
      unset refRef
    }
  }

  Method UpdateBegin {} {
    Vars computed
    unset computed; set computed() {}; unset computed()
  }
  Method UpdateEnd {} {
    Vars computed
    unset computed; set computed() {}; unset computed()
  }
  Method NeedsCompute {} {
    Vars computed inited
    return [expr {![info exists computed([Owner])] && [Owner isShowable 1]}]
  }
  Method BeginInit {} {
    Vars inited
    unset inited; set inited() {}; unset inited()
  }
  Method NeedsInit {} {
    Vars inited
    set owner [Owner]
    set needsinit [expr ![info exists inited($owner)]]
    set inited($owner) 1
    return $needsinit
  }
  Method ComputeReferrers {} {
    Vars computed referrer
    set owner [Owner]
    if [info exists computed($owner)] return
    set computed($owner) 1
    foreach object [array names referrer] {$object Recompute}
    set group [$owner Group]
    if ![$group isTop] {$group Reference ComputeReferrers}
  }

  Method Referrers {{name ""}} {
    Vars referrer
    if {$name == ""} {return [array names referrer]}
    set list {}; set len [string length $name]; set name "$name/"
    foreach object [array names referrer] {
      if {[string compare $name [string range $object 0 $len]] != 0} \
	  {lappend list $object}
    }
    return $list
  }
}

_File AddLoadHook ReferenceData
