Require oo.tcl

ooRoot Subclass PackData {
  ClassVar {data {}} array default

  Method Save {} {
    Vars data array
    foreach var $data {
      set v [lindex $var 1]
      if {$v == ""} {
	if {$array == ""} continue
	set v ${array}($var)
      }
      set [var [lindex $var 0]] [uplevel \#0 set $v]
    }
  }

  Method Restore {} {
    Vars data array
    foreach var $data {
      set v [lindex $var 1]
      if {$v == ""} {
	if {$array == ""} continue
	set v ${array}($var)
      }
      uplevel \#0 [list set $v [val [lindex $var 0]]]
    }
  }

  Method Pack {} {
    set list {}
    foreach var [val data] {lappend list [val [lindex $var 0]]}
    return $list
  }

  Method Unpack {list} {
    set i 0
    if {$list == ""} {set list [val default]}
    foreach var [val data] \
	{set [var [lindex $var 0]] [lindex $list $i]; incr i}
  }

  Method Default {} {return [val default]}
}
