Require button.tcl
Require menu.tcl

ooRoot Instance _SelectObject {
  Var {action {}}
  Var {centered 0}
  Var object

  Method Close {} {
    grab release .olist
    wm withdraw .olist
    update idletasks
  }
  Method Cancel {} {Self Close}

  Method OK {} {
    Vars object action
    if {[.olist.object curselection] == ""} \
	{ErrorOK "You must supply an object."}
    set object [.olist.object get [.olist.object curselection]]
    if {$action != ""} {
      set cmd [concat $action $object]
      set action {}
      uplevel \#0 $cmd
    }
    Self Close
  }

  Method Unlink {} {
    Vars action object
    set object {}
    uplevel \#0 "$action {}"
    Self Close
  }

  Method Request {getobjects action} {
    set [var action] $action
    Self $getobjects [_Current]
    Self Center
    if [winfo ismapped .olist] {wm iconify .olist}
    wm deiconify .olist
    focus .olist
    if {[grab current .] != ""} {grab release [grab current .]}
    grab set .olist
  }

  Method Center {} {
    Vars centered
    if {!$centered} {
      set x [expr [winfo screenwidth .olist]/2 - [winfo reqwidth .olist]/2 - \
		  [winfo vrootx [winfo parent .olist]]]
      set y [expr [winfo screenheight .olist]/3 - [winfo reqheight .olist]/2 -\
		  [winfo vrooty [winfo parent .olist]]]
      wm geom .olist +$x+$y
      set centered 1
    }
  }

  Method LinkableObjects {object} {
    .olist.object(title) configure -text "Link to:"
    if {[$object get linkable-types] != "" ||
        [$object Reference Object] == "_NOOP"} {set state disabled} \
      else {set state normal}
    .olist.unlink configure -state $state
    pack .olist.unlink -before .olist.ok -side left -padx 10 -pady 7 -expand 1
    set current [$object Reference Object]
    set types [$object get linkable-types]
    if {[Self GetObjects $types $object $current] == 0} \
      {Error "'$object' can not link to any other object"}
  }

  Method Groups {object} {
    .olist.object(title) configure -text "Move to Group:"
    pack forget .olist.unlink
    if {[Self GetObjects Group $object [$object Group] 1] == 0} \
      {Error "'$object' can not be moved into any group"}
  }

  Method GetObjects {types name current {groupsOK 0}} {
    foreach type $types {set match($type) 1}
    set i 0; set select ""
    .olist.object delete 0 end
    foreach object [[_Default] ListParts] {
      set parent $object
      while {$parent != "csObject"} {
        set parent [$parent Parent]
        if {$types == "" || $types == "*" || [info exists match($parent)]} {
          if [Self Linkable $name $object $groupsOK] {
            .olist.object insert end $object
            if {[string compare $object $current] == 0} {set select $i}
            incr i
          }
          break
        }
      }
    }
    if {$select == "" && $i == 1} {set select 0}
    if {$select != ""} {
      .olist.object selection set $select
      .olist.object see $select
    }
    return $i
  }

  Method Linkable {name object groupsOK} {
    set dir [string range $object 0 [string length $name]]
    if {[string compare $name $object] == 0 || \
        [string compare "$name/" $dir] == 0} {return 0}
    if {!$groupsOK} {
      while {![$name isTop]} {
        if {$name == $object} {return 0}
        set name [$name Group]
      }
    }
    return 1
  }
}

toplevel .olist
wm withdraw .olist
wm title .olist "$_program(id): Reference Requester"
wm minsize .olist 100 70
wm resizable .olist 1 0

_menu(Scrollable) .olist object "Link to:" 25 5
button .olist.ok -text "OK" -command {_SelectObject OK} -underline 0
button .olist.unlink -text "Unlink" \
  -command {_SelectObject Unlink} -underline 0
button .olist.cancel -text "Cancel" \
  -command {_SelectObject Cancel} -underline 0

pack .olist.cancel -side left -padx 10 -pady 7
pack .olist.unlink -side left -padx 10 -pady 7 -expand 1
pack .olist.ok -side right -padx 10 -pady 7


bind .olist <Return>   {_button(Invoke) .olist.ok}
bind .olist <KP_Enter> {_button(Invoke) .olist.ok}
bind .olist <Alt-o>    {_button(Invoke) .olist.ok}
bind .olist <Alt-c>    {_button(Invoke) .olist.cancel}
bind .olist <Escape>   {_button(Invoke) .olist.cancel}
bind .olist <Alt-u>    {_button(Invoke) .olist.unlink}
bind .olist.object <Double-ButtonRelease-1> {_button(Invoke) .olist.ok}
