Require name.tcl
Require newobj.tcl
Require Class/Group

Group Instance _Object {
  Var {default _Object}
  Var {current _Object} {id -1}
  Var fullnames oldscript

  Method Default {} {val default}
  Method Current {} {val current}
  Method isTop {} {return 1}

  Method Init {} {
    Vars default
    $default Unpack [lreplace [$default Pack] 1 end]
    $default Color set inherit 0
    $default Select
    $default Restore
  }

  Method Show {name} {
    global _object
    Vars id current default oldscript
    if {$name == ""} {set name $default}
    Self SetCurrent $name
    set id [Self getIndex $name]
    if {$id == ""} {set id -1; Self SetCurrent $default}
    .bbox.names selection clear 0 end
    if {$id >= 0} {
      .bbox.names selection set $id
      .bbox.names see $id
      set _object(type) [$current get type]
      if [$current Object get needsUpdate] {
	set _object(update) $_object(updateChar)
      } else {set _object(update) ""}
    } else {
      set _object(type) ""
      set _object(update) ""
    }
    set oldscript [.definition get 0.0 end]
  }

  Method NeedsUpdate {{object ""} {status 1}} {
    global _object
    if {$object == ""} {set object [_Current]}
    $object Object set needsUpdate $status
    if {[string compare $object [val current]] == 0} {
      set [var oldscript] [.definition get 0.0 end]
      if {$status} {set _object(update) $_object(updateChar)} \
	  else {set _object(update) ""}
    }
  }

  Method CheckUpdate {} {
    Vars current oldscript
    if {[$current Object get needsUpdate]} return
    set script [.definition get 0.0 end]
    if {[string compare $script $oldscript] != 0} \
	{_Object NeedsUpdate $current 1}
  }

  Method SetCurrent {name {force 0}} {
    Vars current default
    if {[string compare $current $name] != 0 || $force} {
      if {[string compare $default $name]} {Message Set "Selecting $name..."}
      catch {$current Save; $current Unselect}
      set old $current; set current $name
      Self TemplateMenu $name
      $name _Select
      $name Select; $name Restore
      Self SendGCL $old $current
      Message Clear
    }
  }

  Method SendGCL {old current} {
    puts "(progn"
    catch {
      set oldTop [$old TopGroup]
      if {[string compare $oldTop [$current TopGroup]] != 0} {
	$old StatusCheck 0
	if {[string compare $old $oldTop] != 0} {$oldTop StatusCheck 0}
      }
    }
    $current StatusCheck 1
    puts ")"
    flush stdout
  }

  Method Clear {} {
    Vars default fullnames
    Self Show $default
    foreach object [Self Objects list] {$object _Delete}
    Self Objects clear; set fullnames {}
    Self Display $default
  }

  Method Display {object} {
    Vars fullnames id current
    .bbox.names delete 0 end
    set fullnames [Self ListParts]
    foreach name $fullnames {.bbox.names insert end [Self shortName $name]}
    set oldid $id
    Self Show $object
    if {$id < 0} {
      set name [Self getTitle $oldid]
      if {$name == ""} {
	set name [Self getTitle [expr $oldid-1]]
	if {$name == ""} {
	  set name [Self getTitle 0]
	  if {$name == ""} return
	}
      }
      Self Show $name
    }
  }

  Method shortName {name} {
    regsub -all {[^/]*/} $name { } name
    return $name
  }

  Method getIndex {name} {
    Vars fullnames
    set i 0; set count [llength $fullnames]
    while {[set comp [string compare $name [lindex $fullnames $i]]] != 0 && \
	       $i < $count} {incr i}
    if {$comp == 0} {return $i} else {return ""}
  }

  Method getTitle {index} {return [lindex [val fullnames] $index]}

  Method uniqueName {name} {
    if {[info procs $name] != ""} {
      if {[regexp {[0-9]+$} $name n]} {
        set format "%0[string length $n]d"
        regsub {[0-9]+$} $name {} prefix
        while {[info procs $prefix[format $format [incr n]]] != ""} {}
        set name "$prefix[format $format $n]"
      } else {
        set n 1
        while {[info procs $name-$n] != ""} {incr n}
        set name $name-$n
      }
    }
    return $name
  }

  Method Hit {w} {
    Vars id
    set i [$w curselection]
    if {$i != $id && $i != ""} {
      set object [Self getTitle $i]
      if {$object != ""} {update idletasks; Self Show $object}
    }
  }

  Method CreateGeometry {} {}
  Method DeleteGeometry {} {}

  Method TemplateMenu {name} {
    .mbar.object.menu entryconfigure Template -state disabled
    .mbar.object.menu.template delete 0 end
    foreach template [$name TemplateList] {
      .mbar.object.menu entryconfigure Template -state normal
      .mbar.object.menu.template add command -label $template \
	  -command "_Object TemplateInsert $template"
    }
  }

  Method TemplateInsert {name} {
    Vars current
    catch {eval .definition delete [.definition tag ranges sel]}
    .definition insert insert "[$current Template $name]\n" sel
  }

  Method _New {name type} {Parent Parent _New $name $type}
  Method Save {} {}
  Method Restore {} {
    .definition configure -state normal
    Parent Parent Restore
    .definition configure -state disabled
  }
  Method Update {} {}
  Method UpdateColor {} {}
  Method UpateAppearance {} {}
  Method Select {} {
    .mbar.file configure -state normal
    .mbar.object configure -state normal
    .mbar.help configure -state normal
    .mbar.color configure -state disabled
    .mbar.appearance configure -state disabled
    .mbar.edit configure -state disabled
    .mbar.object.menu entryconfigure Add* -state disabled
    .mbar.object.menu entryconfigure Rename* -state disabled
    .mbar.object.menu entryconfigure Duplicate* -state disabled
    .mbar.object.menu entryconfigure Template -state disabled
    .mbar.object.menu entryconfigure Link* -state disabled
    .mbar.object.menu entryconfigure Move* -state disabled
    .mbar.object.menu entryconfigure Remove* -state disabled
    .mbar.object.menu entryconfigure Delete -state disabled
    .mbar.object.menu entryconfigure Update -state disabled
    .mbar.object.menu entryconfigure Show -state disabled
    .mbar.object.menu entryconfigure Normalize -state disabled
    .mbar.file.menu entryconfigure New -state disabled
    .mbar.file.menu entryconfigure "Save As..." -state disabled
    .mbar.file.menu entryconfigure Revert -state disabled
    .mbar.file.menu entryconfigure Export* -state disabled
    .mbar.file.menu entryconfigure "Save OOGL..." -state disabled
    .mbar.file.menu entryconfigure "Libraries..." -state disabled
    .bbox.update configure -state disabled
    .definition configure -state disabled
    Message Set \
      "Use the OBJECT/NEW menu to create objects, FILE/OPEN to load objects" \
       0 {} 1
  }
  Method Unselect {} {
    .mbar.color configure -state normal
    .mbar.appearance configure -state normal
    .mbar.edit configure -state normal
    .mbar.object.menu entryconfigure Rename* -state normal
    .mbar.object.menu entryconfigure Duplicate* -state normal
    .mbar.object.menu entryconfigure Template -state normal
    .mbar.object.menu entryconfigure Link*  -state normal
    .mbar.object.menu entryconfigure Move*  -state normal
    .mbar.object.menu entryconfigure Remove*  -state normal
    .mbar.object.menu entryconfigure Delete -state normal
    .mbar.object.menu entryconfigure Update -state normal
    .mbar.object.menu entryconfigure Show -state normal
    .mbar.object.menu entryconfigure Normalize -state normal
    .mbar.file.menu entryconfigure New -state normal
    .mbar.file.menu entryconfigure "Save As..." -state normal
    .mbar.file.menu entryconfigure Revert -state normal
    .mbar.file.menu entryconfigure Export* -state normal
    .mbar.file.menu entryconfigure "Save OOGL..." -state normal
    .mbar.file.menu entryconfigure "Libraries..." -state normal
    .bbox.update configure -state normal
    .definition configure -state normal
    Message Clear
  }
  Method HandleOOGL {} {}
  Method WriteOOGL {file} {puts $file "LIST"}
}


proc _Current {} {
  set object [_Object get current]
  if {[info procs $object] == ""} {return "_NOOP"}
  return $object
}
proc _NOOP {args} {}
proc _Default {} "return \[uplevel \#0 set [_Object var default]\]"


bind _object(keymap) <Any-KeyPress> {_Object Hit %W}
bind _object(keymap) <Any-1> {_Object Hit %W}
bind _object(keymap) <Any-2> {_Object Hit %W}
bind _object(keymap) <Any-3> {_Object Hit %W}
bind _object(keymap) <Any-ButtonRelease-1> {_Object Hit %W}
bind _object(keymap) <Any-ButtonRelease-2> {_Object Hit %W}
bind _object(keymap) <Any-ButtonRelease-3> {_Object Hit %W}
bind _object(keymap) <Any-B1-Motion> {_Object Hit %W}

bindtags .bbox.names {.bbox.names Listbox _object(keymap) . all}

bind _update(keymap) <Any-KeyRelease> {_Object CheckUpdate}
bind _update(keymap) <Alt-KeyRelease-u> { }
bindtags .definition [concat _update(keymap) [bindtags .definition]]
