Require label.tcl
Require text.tcl
Require button.tcl
Require menu.tcl

ooRoot Instance _NewObject {
  Var {title ""}
  Var {action {}}
  Var {centered 0}
  Var name type

  Method Close {} {
    grab release .obj
    wm withdraw .obj
    update idletasks
  }
  Method Cancel {} {Self Close}

  Method OK {} {
    Vars name type action
    if {$name == ""} {ErrorOK "You must supply an object name"}
    if {[.obj.type curselection] == ""} \
	{ErrorOK "you must supply an object type"}
    set type [.obj.type get [.obj.type curselection]]
    set name [string trim $name]
    regsub { +} $name {-} name
    if {$action != ""} {
      set cmd [concat $action [list $name $type]]
      set action {}
      uplevel \#0 $cmd
    }
    Self Close
  }

  Method Request {title name action} {
    set [var name]   $name
    set [var action] $action
    set [var title]  $title
    if {$name != ""} {
      if ![regsub {/[^/]*$} $name {/} name] {set name ""}
      .obj.name selection range [string length $name] end
      .obj.name icursor end
    }
    Self GetTypes
    Self Center
    if [winfo ismapped .obj] {wm iconify .obj}
    wm deiconify .obj
    focus .obj.name
    if {[grab current .] != ""} {grab release [grab current .]}
    grab set .obj
  }

  Method Center {} {
    Vars centered
    if {!$centered} {
      set x [expr [winfo screenwidth .obj]/2 - [winfo reqwidth .obj]/2 - \
		  [winfo vrootx [winfo parent .obj]]]
      set y [expr [winfo screenheight .obj]/3 - [winfo reqheight .obj]/2 -\
		  [winfo vrooty [winfo parent .obj]]]
      wm geom .obj +$x+$y
      set centered 1
    }
  }

  Method GetTypes {} {
    set i 0; set surface 0
    .obj.type delete 0 end
    foreach type [lsort [csObject Do {array names [var create]}]] {
      .obj.type insert end $type
      if {$type == "Surface"} {set surface $i}
      incr i
    }
    .obj.type selection set $surface
    .obj.type see $surface
  }
}

toplevel .obj
wm withdraw .obj
wm title .obj "$_program(id): New Object Requester"
wm minsize .obj 100 70
wm resizable .obj 1 0

_menu(Scrollable) .obj type "Object Type:" 15 5
label .obj.title -textvariable [_NewObject var title]
entry .obj.name -width 30 -textvariable [_NewObject var name]
button .obj.ok -text "OK" -command {_NewObject OK} -underline 0
button .obj.cancel -text "Cancel" -command {_NewObject Cancel} -underline 0

pack .obj.title -side top -pady 4
pack .obj.name -side top -fill x -padx 10
pack .obj.cancel -side left -padx 10 -pady 7
pack .obj.ok -side right -padx 10 -pady 7


bind .obj <Return>   {_button(Invoke) .obj.ok}
bind .obj <KP_Enter> {_button(Invoke) .obj.ok}
bind .obj <Alt-o>    {_button(Invoke) .obj.ok}
bind .obj <Alt-c>    {_button(Invoke) .obj.cancel}
bind .obj <Escape>   {_button(Invoke) .obj.cancel}
bind .obj.type <Double-ButtonRelease-1> {_button(Invoke) .obj.ok}