Require button.tcl
Require label.tcl
Require text.tcl

ooRoot Instance _Library {
  Var {list {}}
  Var {action {}}
  Var {centered 0}

  Method Close {} {
    grab release .lib
    wm withdraw .lib
    update idletasks
  }
  Method Cancel {} {Self Close}

  Method OK {} {
    Vars action
    Self Close
    if {$action != ""} {
      set cmd $action
      set action {}
      uplevel \#0 $cmd
    }
  }

  Method Request {} {
    Vars action list
    set action "[Self] _Request"
    .lib.text delete 0.0 end
    .lib.text insert insert [join $list \n]
    .lib.text mark set insert 0.0
    Self Center
    if [winfo ismapped .lib] {wm iconify .lib}
    wm deiconify .lib
    focus .lib.text
    if {[grab current .] != ""} {grab release [grab current .]}
    grab set .lib
  }
  Method _Request {} {
    Self Set [.lib.text get 0.0 end]
    _File Changed 1
  }

  Method Insert {} \
    {_fname(OldFile) "Insert Library:" "" "[Self] _Insert {%N}" .tcl}
  Method _Insert {name} {
    .lib.text tag remove sel 0.0 end
    .lib.text mark set insert {insert lineend +1c}
    if {[.lib.text compare insert != {insert linestart}]} \
	{.lib.text insert insert "\n"}
    .lib.text insert insert "$name\n" sel
  }

  Method Add {names} {
    Vars list
    foreach name $list {set file($name) ""}
    foreach name $names {
      if {![info exists file($name)]} {
	Require $name
	set file($name) ""
      }
    }
    set list [join [lsort [array names file]] " "]
  }

  Method Set {names} {
    Vars list
    set list [join $names " "]
    foreach name $list {Require $name}
  }

  Method Save {file} {
    Vars list
    if {$list != ""} {
      puts -nonewline $file "_Library Add \{\n  "
      puts $file [join $list "\n  "]
      puts $file "\}\n"
    }
  }

  Method Clear {} {set [var list] {}}

  Method Center {} {
    Vars centered
    if {!$centered} {
      set x [expr [winfo screenwidth .lib]/2 - [winfo reqwidth .lib]/2 - \
		  [winfo vrootx [winfo parent .lib]]]
      set y [expr [winfo screenheight .lib]/3 - [winfo reqheight .lib]/2 -\
		  [winfo vrooty [winfo parent .lib]]]
      wm geom .lib +$x+$y
      set centered 1
    }
  }
}

toplevel .lib
wm withdraw .lib
wm title .lib "$_program(id): Library Requester"
wm minsize .lib 200 200

label .lib.title -text "Library list:"
pack .lib.title -side top -pady 3

_text(Scrollable) .lib text 35 10 1 top 1

button .lib.ok -text "OK" -command {_Library OK} -underline 0
button .lib.cancel -text "Cancel" -command {_Library Cancel} -underline 0
button .lib.insert -text "Insert..." -command {_Library Insert} -underline 0

pack .lib.cancel -side left -padx 10 -pady 7
pack .lib.ok -side right -padx 10 -pady 7

frame .lib.pad1; frame .lib.pad2
pack .lib.pad1 -side left -expand 1 -fill both
pack .lib.insert -side left -pady 7
pack .lib.pad2 -side right -expand 1 -fill both

bind .lib <KP_Enter> {_button(Invoke) .lib.ok}
bind .lib <Alt-o>    {_button(Invoke) .lib.ok}
bind .lib <Alt-c>    {_button(Invoke) .lib.cancel}
bind .lib <Alt-i>    {_button(Invoke) .lib.insert}
bind .lib <Escape>   {_button(Invoke) .lib.cancel}
