Require fname.tcl
Require confirm.tcl


ooRoot Instance _File {
  Var filename
  Var {changed 0}
  Var {default Untitled.cs}
  Var "pwd $env(PWD)"
  Var first message base {loading 0}
  Var MV mV ignore
  Var {loadlist {}}

  #
  # minimum version whose data can be read
  #
  Var {majorV  1} {minorV  0}

  Method New {} {
    if [Self Confirm "Delete objects"] return
    _Object Clear
    _Library Clear
    Self Name [val default]
  }

  Method Open {} {
    Vars filename pwd
    if [Self Confirm "Load new objects"] return
    _fname(OldFile) "Load objects from file:" [file tail $filename] \
	"_File _Load {%N} clear" .cs $pwd
  }

  Method Save {} {
    Vars filename default
    if {$filename == $default} {Self SaveAs} else {Self _Save $filename old}
  }

  Method SaveAs {} {
    Vars filename pwd
    _fname(NewFile) "Save objects as:" [file tail $filename] \
	"_File _Save {%N} new" .cs $pwd
  }

  Method Revert {} {
    Vars filename
    if [Self Confirm "Revert to old version of '$filename'"] return
    Self _Load $filename clear
  }

  Method _Save {name new {which all}} {
    global _program _fname
    Vars pwd

    _fname(Close)
    set pwd $_fname(dir)
    set file [open $name w]
    puts $file "\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\#\n\#"
    puts $file "\#  File:     $name"
    puts $file "\#  Created:  [exec date]"
    puts $file "\#  By:       $_program(id)"
    puts $file "\#\n"
    puts $file "_File Version $_program(version)\n"
    _Library Save $file
    [_Current] Save
    if {$which == "all"} {
      foreach object [_Object Objects list] {$object WriteCS $file}
      Self Name $name
    } else {
      [_Current] WriteCS $file "[file dirname [_Current]]/"
    }
    close $file
  }

  Method _Load {name {clear none} {group ""}} {
    global _fname _program
    Vars pwd first message base loading loadlist

    if {![file exists $name]}   {Error "Can't find file '$name'"}
    if {![file readable $name]} {Error "Can't open '$name' for reading"}
    _fname(Close)
    set pwd $_fname(dir)
    [_Current] Save
    if {$clear == "clear"} {
      _Object Clear
      _Library Clear
      Self Name $name
    }
    set first [_Default]
    if {$group != ""} \
	{if [$group isTop] {set group ""} else {set base "$group/"}}
    Self SetV $_program(version)
    Message Set "Loading file '[file tail $name]'..."
    set loading 1; foreach object $loadlist {$object LoadBegin}
    set code [uplevel \#0 [list catch "source $name" [var message]]]
    foreach object $loadlist {$object LoadEnd}; set loading 0
    Message Clear
    Self SetV $_program(version)
    set base ""
    _Object Display $first
    if {$clear == "clear"} {_File Changed 0}
    switch $code {
      0 {} 2 {} 3 {} 4 {}
      1 {
	global errorInfo errorCode
	return -code error -errorinfo $errorInfo -errorcode $errorCode $message
      }
      default {return -code $code $message}
    }
  }

  Method AddLoadHook {name} {lappend [var loadlist] $name}

  Method First {name} {
    Vars first
    if {[string compare $first [_Default]] == 0} {set first $name}
  }

  Method Version {version} {
    Vars majorV minorV ignore MV mV
    Self SetV $version
    set ignore [expr $MV < $majorV || ($MV == $majorV && $mV < $minorV)]
  }

  Method SetV {version} {
    Vars MV mV ignore
    set ignore 0
    set v [split $version .]
    set MV [lindex $v 0]; set mV [lindex $v 1]
    return $MV.$mV
  }

  Method EarlierV {version} {
    Vars MV mV
    set v [split $version .]
    set M [lindex $v 0]; set m [lindex $v 1]
    return [expr $MV < $M || ($MV == $M && $mV < $m)]
  }

  Method Changed {{value {}}} {
    Vars changed
    if {$value == ""} {return $changed}
    set changed $value
  }

  Method Name {name} {
    global env
    Vars filename default

    if {[string range $name 0 [string length $env(PWD)]] == "$env(PWD)/"} \
      {set name [string range $name [expr [string length $env(PWD)] + 1] end]}
    if {$name == ""} {set name $_file(default)}
    set filename $name
    Self SetTitle
    Self Changed 0
  }

  Method SetTitle {} {
    global _program
    Vars filename default

    if {$filename == $default} {
      wm title . $_program(id)
      .mbar.file.menu entryconfigure 3 -state disabled
    } else {
      wm title . "$_program(id): [file tail $filename]"
      .mbar.file.menu entryconfigure 3 -state normal
    }
  }

  Method Confirm {action} {
    Vars changed
    [_Current] Save
    if {! $changed} {return 0}
    Confirm "Warning:  Changes have not been saved.  $action anyway?"
  }

  Method TrapExit {} {
    catch {rename exit _File(exit)}
    proc exit {{code 0}} {
      global _program
      if [_File Confirm "Exit"] return
      catch {
	puts "(progn"
	_Object _Delete
	puts ")"
	flush stdout
      }
      catch {_command(Register) $_program(name) {}}
      uplevel _File(exit) $code
    }
  }
}

_File Name [_File get default]
_File SetV $_program(version)
